/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.client.utils;

import java.net.URI;
import java.net.URISyntaxException;

public final class UrlUtils {
    private UrlUtils() {
    }

    public static String appendUrlPaths(String base, String ... paths) {
        StringBuilder buffer = new StringBuilder(base.length() + 256);
        buffer.append(base);
        for (String path : paths) {
            if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) != '/') {
                buffer.append('/');
            }
            if (path.startsWith("/")) {
                buffer.append(path.substring(1));
                continue;
            }
            buffer.append(path);
        }
        return buffer.toString();
    }

    public static String appendQueryParams(String ... params) {
        return UrlUtils.appendQueryParams(false, params);
    }

    public static String appendQueryParams(boolean includeEmptyParamKeys, String ... params) {
        if (params == null || params.length % 2 != 0) {
            throw new IllegalArgumentException("query parameter mismatch");
        }
        StringBuilder buffer = new StringBuilder(256);
        for (int i = 0; i < params.length - 1; i += 2) {
            String param = params[i];
            String value = params[i + 1];
            if (value != null && !value.isEmpty()) {
                buffer.append(buffer.length() > 0 ? (char)'&' : '?');
                buffer.append(param).append('=').append(UrlUtils.encodeUrlComponent(value));
                continue;
            }
            if (!includeEmptyParamKeys) continue;
            buffer.append(buffer.length() > 0 ? (char)'&' : '?');
            buffer.append(param);
        }
        return buffer.toString();
    }

    public static String resolveUrl(String url, String serverUrl) {
        String resolved = url;
        if (url != null && !url.isEmpty() && !url.matches("[^:/?#]+:.*")) {
            resolved = UrlUtils.appendUrlPaths(serverUrl, url);
        }
        return resolved;
    }

    public static String encodeUrlComponent(String token) {
        try {
            boolean needScheme = token.indexOf(58) >= 0;
            String encoded = new URI(null, null, needScheme ? "S:" + token : token, null, null).toASCIIString();
            encoded = encoded.replace("/", "%2F").replace("~", "%7E").replace(";", "%3B");
            return needScheme ? encoded.substring(2) : encoded;
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }
}

