/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.brain.client;

import com.sonatype.clm.dto.model.sourcecontrol.ApiSourceControlRepositoryUserDTO;
import com.sonatype.insight.client.utils.AbstractClient;
import com.sonatype.insight.client.utils.HttpClientUtils;
import com.sonatype.insight.client.utils.Result;
import com.sonatype.nexus.git.utils.api.GitException;
import com.sonatype.nexus.git.utils.repository.JGitRecentCommitterFinder;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.fasterxml.jackson.databind.ObjectMapper;
import zz.com.fasterxml.jackson.databind.json.JsonMapper;
import zz.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

public class SourceControlClient
extends AbstractClient {
    private static final Logger log = LoggerFactory.getLogger(SourceControlClient.class);
    public static final ObjectMapper mapper = SourceControlClient.defaultMapper();

    public SourceControlClient(HttpClientUtils.Configuration config) {
        super(config);
    }

    public int addOrUpdateSourceControlRecord(String publicId, String repositoryUrl) throws IOException {
        return this.addOrUpdateSourceControlRecord(publicId, repositoryUrl, null);
    }

    public int addOrUpdateSourceControlRecord(String publicId, String repositoryUrl, String repositoryPath) throws IOException {
        Object result = this.path("api", "v2", "sourceControl").query("publicId", publicId, "repositoryUrl", repositoryUrl).post((HttpEntity)this.getApiSourceControlRepositoryUserDTOEntity(repositoryPath));
        this.verifyStatusCode((Result)result);
        return ((Result)result).status();
    }

    private ByteArrayEntity getApiSourceControlRepositoryUserDTOEntity(String repositoryPath) throws IOException {
        Map<Object, Object> recentCommitters = Collections.emptyMap();
        try {
            recentCommitters = this.getRecentCommitters(repositoryPath, 90);
        }
        catch (GitException e) {
            log.warn("Cannot get map of recent committers: {}", (Object)e.getMessage());
        }
        if (!recentCommitters.isEmpty()) {
            ApiSourceControlRepositoryUserDTO apiSourceControlRepoUserDTO = new ApiSourceControlRepositoryUserDTO(recentCommitters);
            return new ByteArrayEntity(mapper.writeValueAsBytes(apiSourceControlRepoUserDTO), ContentType.APPLICATION_JSON);
        }
        return null;
    }

    Map<String, Collection<Instant>> getRecentCommitters(String repositoryPath, int daysPeriod) throws GitException {
        return new JGitRecentCommitterFinder(repositoryPath, daysPeriod).tryGetRecentCommitters();
    }

    private static ObjectMapper defaultMapper() {
        return ((JsonMapper.Builder)JsonMapper.builder().addModule(new JavaTimeModule())).build();
    }
}

