/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.upgrade;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.sonatype.nexus.usertoken.plugin.UserToken;
import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.apikey.store.internal.UserTokenStoreImpl;
import com.sonatype.nexus.usertoken.plugin.legacy.store.internal.orient.OrientUserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.task.LdapSamlDualRealmUserTokensUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.UpgradeTaskScheduler;

@Named
@Singleton
@Upgrades(model="usertoken", from="1.4", to="1.5")
@DependsOn(model="security", version="1.3", checkpoint=true)
public class UserTokenUpgrade_1_5
extends DatabaseUpgradeSupport {
    private static final String P_DOMAIN = "domain";
    private static final String P_PRINCIPALS = "principals";
    private static final String P_API_KEY = "api_key";
    private static final String P_CREATED = "created";
    private static final String DB_API_KEY_CLASS = new OClassNameBuilder().type("api_key").build();
    private static final String GET_USER_TOKEN_API_KEY_RECORDS_PAGINATED_QUERY_STRING = String.format("SELECT FROM %s WHERE %s = :domain ORDER BY %s SKIP :skip LIMIT :limit", DB_API_KEY_CLASS, "domain", "created");
    private final Provider<DatabaseInstance> securityDatabaseInstance;
    private final UpgradeTaskScheduler scheduler;
    private final TaskScheduler taskScheduler;

    @Inject
    public UserTokenUpgrade_1_5(@Named(value="security") @Named(value="security") Provider<DatabaseInstance> securityDatabaseInstance, UpgradeTaskScheduler scheduler, TaskScheduler taskScheduler) {
        this.securityDatabaseInstance = (Provider)Preconditions.checkNotNull(securityDatabaseInstance);
        this.scheduler = (UpgradeTaskScheduler)Preconditions.checkNotNull((Object)scheduler);
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
    }

    public void apply() {
        if (!this.hasDualRealmTokens()) {
            this.log.info("Found no user tokens with multiple realms realms.");
            return;
        }
        this.scheduleTask();
    }

    private void scheduleTask() {
        this.log.info("Scheduling task to fix user tokens with multiple realms.");
        this.scheduler.schedule(this.taskScheduler.createTaskConfigurationInstance("apikey.usertoken.ldapsamldualrealm.singlerealm"));
    }

    private boolean hasDualRealmTokens() {
        AtomicBoolean found = new AtomicBoolean(false);
        UserTokenUpgrade_1_5.withDatabaseAndClass(this.securityDatabaseInstance, (String)DB_API_KEY_CLASS, (db, type) -> {
            List<ODocument> userTokenApiKeyDocuments;
            int page = 1;
            int pageSize = 1000;
            do {
                userTokenApiKeyDocuments = UserTokenUpgrade_1_5.recordsPaginated(db, page++, pageSize);
                this.log.debug("Page {} contains {} records", (Object)page, (Object)userTokenApiKeyDocuments.size());
                boolean pageAffected = userTokenApiKeyDocuments.stream().map(UserTokenUpgrade_1_5::toUserTokenRecord).anyMatch(LdapSamlDualRealmUserTokensUtil::isLdapAndSamlRealm);
                if (!pageAffected) continue;
                this.log.debug("Found user tokens containing multiple realms on page {}", (Object)page);
                found.set(true);
                return;
            } while (userTokenApiKeyDocuments.size() == pageSize);
        });
        return found.get();
    }

    private static List<ODocument> recordsPaginated(ODatabaseDocumentTx db, int page, int pageSize) {
        Preconditions.checkArgument((page > 0 ? 1 : 0) != 0, (Object)"page must be greater than 0");
        Preconditions.checkArgument((pageSize > 0 ? 1 : 0) != 0, (Object)"page size must be greater than 0");
        ImmutableMap params = ImmutableMap.of((Object)P_DOMAIN, (Object)"User-Token-Realm", (Object)"skip", (Object)((page - 1) * pageSize), (Object)"limit", (Object)pageSize);
        return (List)db.command((OCommandRequest)new OCommandSQL(GET_USER_TOKEN_API_KEY_RECORDS_PAGINATED_QUERY_STRING)).execute(new Object[]{params});
    }

    private static UserTokenRecord toUserTokenRecord(ODocument apiKeyUserTokenDocument) {
        PrincipalCollection principals = UserTokenUpgrade_1_5.deserializePrincipals((byte[])apiKeyUserTokenDocument.field(P_PRINCIPALS));
        UserToken userToken = UserTokenStoreImpl.decode(((String)apiKeyUserTokenDocument.field(P_API_KEY)).toCharArray());
        Date created = new Date((Long)apiKeyUserTokenDocument.field(P_CREATED));
        return new OrientUserTokenRecord(principals, userToken, created);
    }

    private static PrincipalCollection deserializePrincipals(byte[] bytes) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayInputStream buffer = new ByteArrayInputStream(bytes);){
                return (PrincipalCollection)new ObjectInputStream(buffer).readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

