/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.sonatype.nexus.usertoken.plugin.UserToken;
import com.sonatype.nexus.usertoken.plugin.legacy.store.internal.orient.OrientUserTokenRecord;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.sonatype.nexus.common.upgrade.Dependencies;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;

@Named
@Singleton
@Upgrades(model="usertoken", from="1.3", to="1.4")
@Dependencies(value={@DependsOn(model="security", version="1.3", checkpoint=true), @DependsOn(model="api_key", version="1.1", checkpoint=true)})
public class UserTokenUpgrade_1_4
extends DatabaseUpgradeSupport {
    private static final String P_USERNAME = "username";
    private static final String P_NAMECODE = "namecode";
    private static final String P_PASSCODE = "passcode";
    private static final String P_PRINCIPALS = "principals";
    private static final String P_CREATED = "created";
    private static final String LOCAL_USER_SOURCE = "default";
    private static final String DB_USERTOKEN_CLASS = new OClassNameBuilder().prefix("usertoken").type("record").build();
    private static final String DB_USER_ROLE_CLASS = new OClassNameBuilder().type("user_role_mapping").build();
    private static final String DB_API_KEY_CLASS = new OClassNameBuilder().type("api_key").build();
    private static final String QUERY_GET_LOCAL_USERS = String.format("SELECT userId FROM %s WHERE source = '%s'", DB_USER_ROLE_CLASS, "default");
    private static final String QUERY_GET_USERNAMES_FROM_USER_TOKENS = String.format("SELECT username FROM %s ORDER BY created DESC", DB_USERTOKEN_CLASS);
    private static final String QUERY_UPDATE_USERNAMES = String.format("UPDATE %s SET username = ? WHERE username = ?", DB_USERTOKEN_CLASS);
    private static final String QUERY_INSERT_API_KEY_RECORD = String.format("INSERT INTO %s (primary_principal, domain, api_key, principals, created) VALUES(?, ?, ?, ?, ?)", DB_API_KEY_CLASS);
    private static final String QUERY_GET_ALL_USER_TOKEN_RECORDS = String.format("SELECT FROM %s", DB_USERTOKEN_CLASS);
    private static final String QUERY_DELETE_USERTOKEN_BY_USERNAME = String.format("DELETE FROM %s WHERE username = ?", DB_USERTOKEN_CLASS);
    private static final String QUERY_FIND_MIGRATED = String.format("SELECT FROM %s WHERE domain = ?", DB_API_KEY_CLASS);
    private static final String QUERY_FIND_DOCUMENT_BY_RID = "SELECT FROM ?";
    private final Provider<DatabaseInstance> securityDatabaseInstance;

    @Inject
    public UserTokenUpgrade_1_4(@Named(value="security") @Named(value="security") Provider<DatabaseInstance> securityDatabaseInstance) {
        this.securityDatabaseInstance = (Provider)Preconditions.checkNotNull(securityDatabaseInstance);
    }

    public void apply() throws Exception {
        if (this.hasMigratedTokens()) {
            this.log.info("Migration of user tokens already completed. Skipping");
            return;
        }
        List<String> localUsers = this.detectLocalUsers();
        this.removeProblematicUserTokens(localUsers);
        this.updateUserTokenWithCorrectUserNames(localUsers);
        this.migrateUserTokensToApiKey();
    }

    private boolean hasMigratedTokens() {
        boolean[] migrated = new boolean[1];
        UserTokenUpgrade_1_4.withDatabaseAndClass(this.securityDatabaseInstance, (String)DB_USERTOKEN_CLASS, (db, type) -> {
            List documents = (List)db.command((OCommandRequest)new OCommandSQL(QUERY_FIND_MIGRATED)).execute(new Object[]{"User-Token-Realm"});
            blArray[0] = !documents.isEmpty();
        });
        return migrated[0];
    }

    private List<String> detectLocalUsers() {
        ArrayList<String> ids = new ArrayList<String>();
        UserTokenUpgrade_1_4.withDatabaseAndClass(this.securityDatabaseInstance, (String)DB_USER_ROLE_CLASS, (db, type) -> {
            List<String> userIds = UserTokenUpgrade_1_4.execute((ODatabaseDocument)db, QUERY_GET_LOCAL_USERS, "userId", new Object[0]);
            this.log.debug("Detected local realm users: {}", userIds);
            ids.addAll(userIds);
        });
        return ids;
    }

    private void removeProblematicUserTokens(List<String> localUserIds) {
        UserTokenUpgrade_1_4.withDatabaseAndClass(this.securityDatabaseInstance, (String)DB_USERTOKEN_CLASS, (db, type) -> {
            List lowerCaseIds = localUserIds.stream().map(String::toLowerCase).collect(Collectors.toList());
            Set<String> duplicates = lowerCaseIds.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(list -> (Long)list.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
            duplicates.forEach(username -> {
                int deleted = (Integer)db.command((OCommandRequest)new OCommandSQL(QUERY_DELETE_USERTOKEN_BY_USERNAME)).execute(new Object[]{username});
                if (deleted > 0) {
                    this.log.info("Invalidated user token for {}", username);
                }
            });
        });
    }

    private void updateUserTokenWithCorrectUserNames(List<String> localUserIds) {
        UserTokenUpgrade_1_4.withDatabaseAndClass(this.securityDatabaseInstance, (String)DB_USERTOKEN_CLASS, (db, type) -> {
            List<String> usernamesFromTokens = UserTokenUpgrade_1_4.execute((ODatabaseDocument)db, QUERY_GET_USERNAMES_FROM_USER_TOKENS, P_USERNAME, new Object[0]);
            localUserIds.removeAll(usernamesFromTokens);
            localUserIds.forEach(username -> {
                int updated = (Integer)db.command((OCommandRequest)new OCommandSQL(QUERY_UPDATE_USERNAMES)).execute(new Object[]{username, username.toLowerCase()});
                if (updated > 0) {
                    this.log.info("User token for {} updated to use case sensitive username", username);
                }
            });
        });
    }

    private void migrateUserTokensToApiKey() {
        UserTokenUpgrade_1_4.withDatabaseAndClass(this.securityDatabaseInstance, (String)DB_USERTOKEN_CLASS, (db, type) -> {
            List documents = (List)db.command((OCommandRequest)new OCommandSQL(QUERY_GET_ALL_USER_TOKEN_RECORDS)).execute(new Object[0]);
            documents.forEach(document -> {
                String username = (String)document.field(P_USERNAME);
                OrientUserTokenRecord userTokenRecord = this.extractUserTokenRecord((ODocument)document);
                this.log.debug("Migrating user token for {} with token {}", (Object)username, (Object)userTokenRecord.getUserToken().render());
                try {
                    ODocument createdDocument = UserTokenUpgrade_1_4.createApiKeyRecord(db, username, userTokenRecord);
                    if (createdDocument != null) {
                        this.log.info("User token for {} migrated from {} to {}", new Object[]{username, DB_USERTOKEN_CLASS, DB_API_KEY_CLASS});
                    }
                }
                catch (ORecordDuplicatedException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Error inserting duplicate user-token record", (Throwable)e);
                    }
                    this.updateApiKeyIfNeeded((ODatabaseDocumentTx)db, e.getRid(), userTokenRecord, username);
                }
            });
        });
    }

    private void updateApiKeyIfNeeded(ODatabaseDocumentTx db, ORID rid, OrientUserTokenRecord userTokenRecord, String username) {
        List apiKeys = (List)db.command((OCommandRequest)new OCommandSQL(QUERY_FIND_DOCUMENT_BY_RID)).execute(new Object[]{rid});
        apiKeys.stream().findFirst().ifPresent(apiKeyDoc -> {
            OffsetDateTime apiKeyCreated = this.extractApiCreated((ODocument)apiKeyDoc);
            OffsetDateTime userTokenCreated = this.convertToOffsetDateTime(userTokenRecord.getCreated());
            if (apiKeyCreated != null && userTokenCreated.isAfter(apiKeyCreated)) {
                apiKeyDoc.delete();
                ODocument apiKeyRecord = UserTokenUpgrade_1_4.createApiKeyRecord(db, username, userTokenRecord);
                if (apiKeyRecord != null) {
                    this.log.info("User token for {} migrated from {} to {}", new Object[]{username, DB_USERTOKEN_CLASS, DB_API_KEY_CLASS});
                }
            } else {
                this.log.info("Skipping {} migration cause the same record already migrated", (Object)userTokenRecord);
            }
        });
    }

    private OffsetDateTime convertToOffsetDateTime(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        Instant instant = gregorianCalendar.toInstant();
        ZoneId zoneId = ZoneId.of("UTC");
        return instant.atZone(zoneId).toOffsetDateTime();
    }

    private OffsetDateTime extractApiCreated(ODocument document) {
        Long createdTimestamp = (Long)document.field(P_CREATED, OType.LONG);
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(createdTimestamp), ZoneOffset.UTC);
    }

    private static ODocument createApiKeyRecord(ODatabaseDocumentTx db, String username, OrientUserTokenRecord userTokenRecord) {
        return (ODocument)db.command((OCommandRequest)new OCommandSQL(QUERY_INSERT_API_KEY_RECORD)).execute(new Object[]{username, "User-Token-Realm", userTokenRecord.getUserToken().render(), UserTokenUpgrade_1_4.serializePrincipals(userTokenRecord.getPrincipals()), userTokenRecord.getCreated().toInstant().toEpochMilli()});
    }

    private OrientUserTokenRecord extractUserTokenRecord(ODocument userTokenDocument) {
        PrincipalCollection principals = UserTokenUpgrade_1_4.deserializePrincipals((byte[])userTokenDocument.field(P_PRINCIPALS));
        String nameCode = (String)userTokenDocument.field(P_NAMECODE);
        String passCode = (String)userTokenDocument.field(P_PASSCODE);
        UserToken token = new UserToken(nameCode, passCode);
        Date created = (Date)userTokenDocument.field(P_CREATED);
        return new OrientUserTokenRecord(principals, token, created);
    }

    private static List<String> execute(ODatabaseDocument db, String query, String field, Object ... args) {
        List nameDocuments = (List)db.command((OCommandRequest)new OCommandSQL(query)).execute(args);
        return nameDocuments.stream().map(o -> (String)o.field(field, String.class)).collect(Collectors.toList());
    }

    private static PrincipalCollection deserializePrincipals(byte[] bytes) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayInputStream buff = new ByteArrayInputStream(bytes);){
                return (PrincipalCollection)new ObjectInputStream(buff).readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] serializePrincipals(PrincipalCollection object) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayOutputStream buff = new ByteArrayOutputStream();){
                ObjectOutputStream out = new ObjectOutputStream(buff);
                out.writeObject(object);
                out.close();
                return buff.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

