/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;

@Named
@Singleton
@Upgrades(model="usertoken", from="1.0", to="1.1")
@DependsOn(model="security", version="1.0", checkpoint=true)
public class UserTokenUpgrade_1_1
extends DatabaseUpgradeSupport {
    private static final String DB_CLASS = new OClassNameBuilder().prefix("usertoken").type("record").build();
    private static final String QUERY = String.format("UPDATE %s SET username = username.toLowerCase()", DB_CLASS);
    private static final String QUERY_HAS_DUPLICATES = String.format("SELECT u FROM (SELECT u, count(*) as C FROM (SELECT username.toLowerCase() as u FROM %s) GROUP BY u) WHERE C > 1", DB_CLASS);
    private static final String QUERY_FIND_DUPLICATES = String.format("SELECT username FROM %s WHERE username.toLowerCase() = ? ORDER BY created DESC", DB_CLASS);
    private static final String QUERY_REMOVE_DUPLICATE = String.format("DELETE FROM %s WHERE username IN ?", DB_CLASS);
    private final Provider<DatabaseInstance> securityDatabaseInstance;

    @Inject
    public UserTokenUpgrade_1_1(@Named(value="security") @Named(value="security") Provider<DatabaseInstance> securityDatabaseInstance) {
        this.securityDatabaseInstance = (Provider)Preconditions.checkNotNull(securityDatabaseInstance);
    }

    public void apply() {
        UserTokenUpgrade_1_1.withDatabaseAndClass(this.securityDatabaseInstance, (String)DB_CLASS, (db, type) -> {
            List<String> names = UserTokenUpgrade_1_1.execute((ODatabaseDocument)db, QUERY_HAS_DUPLICATES, "u", new Object[0]);
            names.forEach(name -> {
                List<String> duplicates = UserTokenUpgrade_1_1.execute((ODatabaseDocument)db, QUERY_FIND_DUPLICATES, "username", name);
                db.command((OCommandRequest)new OCommandSQL(QUERY_REMOVE_DUPLICATE)).execute(new Object[]{duplicates.subList(1, duplicates.size())});
            });
        });
        UserTokenUpgrade_1_1.withDatabaseAndClass(this.securityDatabaseInstance, (String)DB_CLASS, (db, type) -> {
            int updates = (Integer)db.command((OCommandRequest)new OCommandSQL(QUERY)).execute(new Object[0]);
            if (updates > 0) {
                this.log.info("Updated {} user tokens converting names to lowercase.", (Object)updates);
            }
        });
    }

    private static List<String> execute(ODatabaseDocument db, String query, String field, Object ... args) {
        List nameDocuments = (List)db.command((OCommandRequest)new OCommandSQL(query)).execute(args);
        return nameDocuments.stream().map(o -> (String)o.field(field, String.class)).collect(Collectors.toList());
    }
}

