/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.task;

import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.apache.shiro.subject.PrincipalCollection;

public class LdapSamlDualRealmUserTokensUtil {
    public static final String SAML_REALM_NAME = "SamlRealm";
    public static final String LDAP_REALM_NAME = "LdapRealm";

    private LdapSamlDualRealmUserTokensUtil() {
    }

    public static boolean hasLdapSamlDualRealmUserTokens(Collection<UserTokenRecord> userTokenRecords) {
        return userTokenRecords.stream().anyMatch(LdapSamlDualRealmUserTokensUtil::isLdapAndSamlRealm);
    }

    public static boolean isLdapAndSamlRealm(UserTokenRecord userToken) {
        return Optional.of(userToken).map(UserTokenRecord::getPrincipals).map(PrincipalCollection::getRealmNames).filter(realms -> realms.size() == 2).map(realms -> realms.containsAll(Arrays.asList(LDAP_REALM_NAME, SAML_REALM_NAME))).orElse(false);
    }
}

