/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.task;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.apikey.store.UserTokenStore;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.sonatype.nexus.common.time.DateHelper;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.logging.task.TaskLogType;
import org.sonatype.nexus.logging.task.TaskLogging;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.scheduling.Task;
import org.sonatype.nexus.scheduling.TaskSupport;
import org.sonatype.nexus.security.SecuritySystem;
import org.sonatype.nexus.security.user.NoSuchUserManagerException;
import org.sonatype.nexus.security.user.User;
import org.sonatype.nexus.security.user.UserManager;
import org.sonatype.nexus.security.user.UserNotFoundException;

@Named
@TaskLogging(value=TaskLogType.BOTH)
public class LdapSamlDualRealmUserTokensTask
extends TaskSupport
implements Task,
Cancelable {
    private static final int PAGE_SIZE = 1000;
    private static final String SAML_USER_SOURCE = "SAML";
    private static final String LDAP_USER_SOURCE = "LDAP";
    private final Set<Exception> shownUserLookupExceptions = new HashSet<Exception>();
    private final UserTokenStore userTokenStore;
    private final UserManager samlUserManager;
    private final UserManager ldapUserManager;
    private int processed = 0;
    private int modified = 0;
    private int deleted = 0;

    @Inject
    public LdapSamlDualRealmUserTokensTask(UserTokenStore userTokenStore, SecuritySystem securitySystem) throws NoSuchUserManagerException {
        this.userTokenStore = (UserTokenStore)Preconditions.checkNotNull((Object)userTokenStore);
        this.samlUserManager = ((SecuritySystem)Preconditions.checkNotNull((Object)securitySystem)).getUserManager(SAML_USER_SOURCE);
        this.ldapUserManager = ((SecuritySystem)Preconditions.checkNotNull((Object)securitySystem)).getUserManager(LDAP_USER_SOURCE);
    }

    public String getMessage() {
        return "Transforms LDAP-SAML dual-realm user tokens into single-realm user tokens";
    }

    public Object execute() throws Exception {
        block15: {
            boolean isSamlConfigured = this.samlUserManager.isConfigured();
            boolean isLdapConfigured = this.ldapUserManager.isConfigured();
            this.log.info("Beginning user token migration. LDAP Configured:{}, SAML Configured:{}", (Object)isLdapConfigured, (Object)isSamlConfigured);
            Throwable throwable = null;
            Object var4_5 = null;
            ProgressLogIntervalHelper progress = new ProgressLogIntervalHelper(this.log, 60);
            try {
                Collection<UserTokenRecord> userTokenRecords;
                int page = 1;
                do {
                    userTokenRecords = this.userTokenStore.recordsPaginated(page++, 1000);
                    this.processed += userTokenRecords.size();
                    List<UserTokenRecord> ldapSamlDualRealmUserTokenRecords = LdapSamlDualRealmUserTokensTask.getLdapSamlDualRealmUserTokenRecords(userTokenRecords);
                    for (UserTokenRecord referenceUserTokenRecord : ldapSamlDualRealmUserTokenRecords) {
                        CancelableHelper.checkCancellation();
                        boolean hasSamlToken = this.hasSamlToken(referenceUserTokenRecord.getUserName());
                        boolean hasLdapToken = this.hasLdapToken(referenceUserTokenRecord.getUserName());
                        if (isSamlConfigured && !hasSamlToken) {
                            this.cacheSamlUser(referenceUserTokenRecord.getUserName());
                            this.updateToken(referenceUserTokenRecord, "SamlRealm");
                        } else if (!hasLdapToken) {
                            this.updateToken(referenceUserTokenRecord, "LdapRealm");
                        } else {
                            this.log.warn("Unable to migrate {}. {}", (Object)referenceUserTokenRecord.getUserName(), (Object)LdapSamlDualRealmUserTokensTask.unableToMigrateMessage(isLdapConfigured, isSamlConfigured, hasLdapToken, hasSamlToken));
                            this.deleteToken(referenceUserTokenRecord);
                        }
                        progress.info("Processed {} tokens, updated {} tokens, removed {} tokens", new Object[]{this.processed, this.modified, this.deleted});
                    }
                } while (userTokenRecords.size() == 1000);
                if (progress == null) break block15;
            }
            catch (Throwable throwable2) {
                try {
                    if (progress != null) {
                        progress.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            progress.close();
        }
        return null;
    }

    private boolean hasLdapToken(String userName) {
        return this.userTokenStore.get(userName, "LdapRealm") != null;
    }

    private boolean hasSamlToken(String userName) {
        return this.userTokenStore.get(userName, "SamlRealm") != null;
    }

    private void updateToken(UserTokenRecord existingUserTokenRecord, String targetRealm) {
        try {
            SimplePrincipalCollection principals = new SimplePrincipalCollection();
            principals.add((Object)existingUserTokenRecord.getUserName(), targetRealm);
            UserTokenRecord updatedUserToken = this.userTokenStore.newUserTokenRecord((PrincipalCollection)principals, existingUserTokenRecord.getUserToken(), DateHelper.toOffsetDateTime((Date)existingUserTokenRecord.getCreated()));
            this.userTokenStore.update(existingUserTokenRecord, updatedUserToken);
            this.log.info("Migrated user token for {} to {}", existingUserTokenRecord.getPrincipals().getPrimaryPrincipal(), (Object)targetRealm);
            ++this.modified;
        }
        catch (Exception e) {
            this.log.error("Unable to move token for user {} to {}. Removing token.", new Object[]{existingUserTokenRecord.getUserName(), targetRealm, e});
            this.deleteToken(existingUserTokenRecord);
        }
    }

    private void deleteToken(UserTokenRecord existingUserTokenRecord) {
        this.userTokenStore.remove(existingUserTokenRecord.getPrincipals());
        ++this.deleted;
    }

    private void cacheSamlUser(String userId) {
        try {
            User user = this.ldapUserManager.getUser(userId);
            if (user == this.samlUserManager.addUser(user, null)) {
                this.log.info("Created SAML cache for {}", (Object)userId);
            } else {
                this.log.debug("Existing SAML cache for {}", (Object)userId);
            }
        }
        catch (UserNotFoundException userNotFoundException) {
            this.log.warn("Unable to locate user {} in the LDAP servers. User token will have no roles", (Object)userId);
        }
        catch (Exception e) {
            this.log.warn("Unable to create SAML cache for user {}. User token will have no associated permissions until user logs in", (Object)userId, (Object)(this.shownUserLookupExceptions.contains(e) ? null : e));
            this.shownUserLookupExceptions.add(e);
        }
    }

    private static String unableToMigrateMessage(boolean hasLdapConfigured, boolean hasSamlConfigured, boolean hasLdapToken, boolean hasSamlToken) {
        if (hasLdapToken && hasSamlToken) {
            return "User has existing tokens in both LDAP and SAML.";
        }
        if (hasSamlConfigured && !hasLdapConfigured) {
            return "User has existing token in SAML, and LDAP is not configured.";
        }
        if (!hasSamlConfigured && hasLdapConfigured) {
            return "User has existing token in LDAP, and SAML is not configured.";
        }
        return "Neither SAML nor LDAP realms are configured.";
    }

    private static List<UserTokenRecord> getLdapSamlDualRealmUserTokenRecords(Collection<UserTokenRecord> userTokenRecords) {
        return userTokenRecords.stream().filter(userTokenRecord -> userTokenRecord.getPrincipals().getRealmNames().size() == 2).filter(userTokenRecord -> userTokenRecord.getPrincipals().getRealmNames().containsAll(Arrays.asList("LdapRealm", "SamlRealm"))).collect(Collectors.toList());
    }
}

