/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.rest.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.usertoken.plugin.UserTokenService;
import com.sonatype.nexus.usertoken.plugin.rest.internal.resources.doc.ResetUserTokenApiResourceDoc;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.security.SecuritySystem;
import org.sonatype.nexus.security.anonymous.AnonymousHelper;
import org.sonatype.nexus.security.realm.RealmManager;
import org.sonatype.nexus.security.realm.SecurityRealm;
import org.sonatype.nexus.security.user.UserManager;
import org.sonatype.nexus.security.user.UserNotFoundException;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public abstract class ResetUserTokenApiResource
extends ComponentSupport
implements Resource,
ResetUserTokenApiResourceDoc {
    public static final String NEXUS_AUTHORIZING_REALM = "NexusAuthorizingRealm";
    public static final String NEXUS_AUTHENTICATING_REALM = "NexusAuthenticatingRealm";
    private final UserTokenService userTokenService;
    private final SecuritySystem securitySystem;
    private final RealmManager realmManager;
    private final List<String> authenticationRealms;

    protected ResetUserTokenApiResource(UserTokenService userTokenService, SecuritySystem securitySystem, RealmManager realmManager, List<UserManager> userManagers) {
        this.userTokenService = (UserTokenService)Preconditions.checkNotNull((Object)userTokenService);
        this.securitySystem = (SecuritySystem)Preconditions.checkNotNull((Object)securitySystem);
        this.realmManager = (RealmManager)Preconditions.checkNotNull((Object)realmManager);
        this.authenticationRealms = AnonymousHelper.getAuthenticationRealms((List)((List)Preconditions.checkNotNull(userManagers)));
    }

    @Override
    @DELETE
    @Path(value="{userId}/{realm}/user-token-reset")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:usertoken-user:delete"})
    public void reset(@NotNull @PathParam(value="userId") String userId, @NotNull @PathParam(value="realm") String realm) {
        this.checkIfUserTokenServiceIsEnabled();
        this.validateRealm(realm);
        try {
            this.securitySystem.getUser(userId);
        }
        catch (UserNotFoundException unfe) {
            this.handleUserNotFound(userId, unfe);
        }
        this.userTokenService.remove(userId, realm);
    }

    private void checkIfUserTokenServiceIsEnabled() {
        if (!this.userTokenService.isEnabled()) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)"\"User tokens are not enabled.\"", "application/json");
        }
    }

    private void validateRealm(String realm) {
        List<String> securityRealmIds = this.getAllRealmIds();
        if (securityRealmIds.stream().noneMatch(r -> r.equals(realm))) {
            throw new WebApplicationMessageException(422, (Object)"\"Realm name is not valid.\"", "application/json");
        }
    }

    private List<String> getAllRealmIds() {
        return this.realmManager.getAvailableRealms(true).stream().map(SecurityRealm::getId).filter(this.authenticationRealms::contains).map(id -> id.equals(NEXUS_AUTHORIZING_REALM) ? NEXUS_AUTHENTICATING_REALM : id).collect(Collectors.toList());
    }

    private void handleUserNotFound(String userId, UserNotFoundException unfe) {
        this.log.debug("Unable to locate userId: {}", (Object)userId, (Object)unfe);
        throw new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)("\"User '" + userId + "' not found.\""), "application/json");
    }
}

