/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.legacy.store.internal.orient;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.sonatype.nexus.usertoken.plugin.UserToken;
import com.sonatype.nexus.usertoken.plugin.legacy.store.internal.orient.OrientUserTokenRecord;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.DeleteEntitiesAction;
import org.sonatype.nexus.orient.entity.action.DeleteEntityByPropertyAction;
import org.sonatype.nexus.security.NexusSimplePrincipalCollection;

@Named
@Singleton
public class OrientUserTokenRecordEntityAdapter
extends IterableEntityAdapter<OrientUserTokenRecord> {
    private static final String DB_CLASS = new OClassNameBuilder().prefix("usertoken").type("record").build();
    private static final String P_USERNAME = "username";
    private static final String P_PRINCIPALS = "principals";
    private static final String P_NAMECODE = "namecode";
    private static final String P_PASSCODE = "passcode";
    private static final String P_CREATED = "created";
    private static final String P_EXPIRED_TIME = "expired";
    private static final String I_USERNAME = new OIndexNameBuilder().type(DB_CLASS).property("username").build();
    private static final String I_NAMECODE = new OIndexNameBuilder().type(DB_CLASS).property("namecode").build();
    private final DeleteEntitiesAction deleteAll = new DeleteEntitiesAction((EntityAdapter)this);
    private final DeleteEntityByPropertyAction deleteByNameCode = new DeleteEntityByPropertyAction((EntityAdapter)this, new String[]{"namecode"});
    private static final String COUNT_QUERY = String.format("SELECT COUNT(*) FROM %s", DB_CLASS);
    private static final String GET_USERNAME_QUERY = String.format("SELECT FROM %s WHERE %s = ?", DB_CLASS, "username");
    private static final String GET_NAMECODE_QUERY = String.format("SELECT FROM %s WHERE %s = ?", DB_CLASS, "namecode");
    private static final String GET_QUERY_ORDERED_BY_DATE = String.format("SELECT FROM %s ORDER BY %s", DB_CLASS, "created");
    private static final String GET_BY_CREATED_DATE_QUERY_ORDERED_BY_DATE = String.format("SELECT FROM %s WHERE %s > ? ORDER BY %s", DB_CLASS, "created", "created");
    private static final String EXPIRED_QUERY_STRING = String.format("SELECT FROM %s WHERE %s < :expired", DB_CLASS, "created");

    public OrientUserTokenRecordEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(ODatabaseDocumentTx db, OClass type) {
        super.defineType(db, type);
        this.enableRecordEncryption(db, type);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_USERNAME, OType.STRING);
        type.createProperty(P_NAMECODE, OType.STRING);
        type.createIndex(I_USERNAME, OClass.INDEX_TYPE.NOTUNIQUE, new String[]{P_USERNAME});
        type.createIndex(I_NAMECODE, OClass.INDEX_TYPE.UNIQUE, new String[]{P_NAMECODE});
    }

    protected OrientUserTokenRecord newEntity() {
        throw new UnsupportedOperationException();
    }

    protected void readFields(ODocument document, OrientUserTokenRecord entity) {
        throw new UnsupportedOperationException();
    }

    public OrientUserTokenRecord readEntity(OIdentifiable identifiable) {
        ODocument document = (ODocument)identifiable.getRecord();
        PrincipalCollection principals = OrientUserTokenRecordEntityAdapter.deserialize((byte[])document.field(P_PRINCIPALS));
        String nameCode = (String)document.field(P_NAMECODE);
        String passCode = (String)document.field(P_PASSCODE);
        UserToken token = new UserToken(nameCode, passCode);
        Date created = (Date)document.field(P_CREATED);
        OrientUserTokenRecord entity = new OrientUserTokenRecord(principals, token, created);
        this.attachMetadata((Entity)entity, document);
        return entity;
    }

    protected void writeFields(ODocument document, OrientUserTokenRecord entity) {
        document.field(P_PRINCIPALS, (Object)OrientUserTokenRecordEntityAdapter.serialize(entity.getPrincipals()));
        document.field(P_USERNAME, (Object)entity.getUserName());
        document.field(P_NAMECODE, (Object)entity.getNameCode());
        document.field(P_PASSCODE, (Object)new String(entity.getPassCode()));
        document.field(P_CREATED, (Object)entity.getCreated());
    }

    public long count(ODatabaseDocumentTx db) {
        Preconditions.checkNotNull((Object)db);
        List result = (List)db.command((OCommandRequest)new OSQLSynchQuery(COUNT_QUERY)).execute(new Object[0]);
        return (Long)((ODocument)result.get(0)).field("COUNT");
    }

    public boolean contains(ODatabaseDocumentTx db, String username, String realm) {
        List result = (List)db.command((OCommandRequest)new OSQLSynchQuery(GET_USERNAME_QUERY)).execute(new Object[]{username});
        List tokens = result.stream().map(this::readEntity).collect(Collectors.toList());
        return tokens.stream().anyMatch(token -> token.getPrincipals().getRealmNames().contains(realm));
    }

    @Nullable
    public OrientUserTokenRecord get(ODatabaseDocumentTx db, String userName, String realm) {
        List<OrientUserTokenRecord> tokens = this.getUserTokensFromUserName(db, userName);
        Optional<OrientUserTokenRecord> tokenResult = tokens.stream().filter(token -> token.getPrincipals().getRealmNames().contains(realm)).findFirst();
        return tokenResult.isPresent() ? tokenResult.get() : null;
    }

    @Nullable
    public OrientUserTokenRecord get(ODatabaseDocumentTx db, String userName, Set<String> realms) {
        List<OrientUserTokenRecord> tokens = this.getUserTokensFromUserName(db, userName);
        for (OrientUserTokenRecord token : tokens) {
            if (Collections.disjoint(token.getPrincipals().getRealmNames(), realms)) continue;
            return token;
        }
        return null;
    }

    private List<OrientUserTokenRecord> getUserTokensFromUserName(ODatabaseDocumentTx db, String userName) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)userName);
        List result = (List)db.command((OCommandRequest)new OSQLSynchQuery(GET_USERNAME_QUERY)).execute(new Object[]{userName});
        return result.stream().map(this::readEntity).collect(Collectors.toList());
    }

    @Nullable
    public OrientUserTokenRecord get(ODatabaseDocumentTx db, String nameCode) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)nameCode);
        List result = (List)db.command((OCommandRequest)new OSQLSynchQuery(GET_NAMECODE_QUERY)).execute(new Object[]{nameCode});
        return result == null || result.isEmpty() ? null : this.readEntity((OIdentifiable)result.get(0));
    }

    public Iterator<OrientUserTokenRecord> get(ODatabaseDocumentTx db, Date createdSince) {
        Preconditions.checkNotNull((Object)db);
        String queryString = createdSince == null ? GET_QUERY_ORDERED_BY_DATE : GET_BY_CREATED_DATE_QUERY_ORDERED_BY_DATE;
        List result = (List)db.command((OCommandRequest)new OSQLSynchQuery(queryString)).execute(new Object[]{createdSince});
        if (result != null) {
            return Iterators.transform(result.iterator(), this::readEntity);
        }
        return Collections.emptyIterator();
    }

    public Iterator<OrientUserTokenRecord> getAll(ODatabaseDocumentTx db) {
        Preconditions.checkNotNull((Object)db);
        return Iterators.transform((Iterator)db.browseClass(DB_CLASS).iterator(), (Function)new Function<ODocument, OrientUserTokenRecord>(){

            public OrientUserTokenRecord apply(ODocument document) {
                return OrientUserTokenRecordEntityAdapter.this.readEntity((OIdentifiable)document);
            }
        });
    }

    private static PrincipalCollection deserialize(byte[] bytes) {
        try {
            return (PrincipalCollection)new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static byte[] serialize(PrincipalCollection object) {
        PrincipalCollection objectToSerialize = object;
        try {
            if (object instanceof NexusSimplePrincipalCollection) {
                NexusSimplePrincipalCollection nexusSimplePrincipalCollection = (NexusSimplePrincipalCollection)object;
                String realm = nexusSimplePrincipalCollection.getRealmName();
                objectToSerialize = new SimplePrincipalCollection(nexusSimplePrincipalCollection.fromRealm(realm), realm);
            }
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buff);
            out.writeObject(objectToSerialize);
            out.close();
            return buff.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void deleteAll(ODatabaseDocumentTx db) {
        this.deleteAll.execute(db);
    }

    public boolean deleteByUserNameAndRealm(ODatabaseDocumentTx db, String userName, String realm) {
        List results = (List)db.command((OCommandRequest)new OSQLSynchQuery(GET_USERNAME_QUERY)).execute(new Object[]{userName});
        for (ODocument result : results) {
            if (!this.readEntity((OIdentifiable)result).getPrincipals().getRealmNames().contains(realm)) continue;
            result.delete();
            return true;
        }
        return false;
    }

    public boolean deleteByUserNameAndRealm(ODatabaseDocumentTx db, String userName, Set<String> realms) {
        List results = (List)db.command((OCommandRequest)new OSQLSynchQuery(GET_USERNAME_QUERY)).execute(new Object[]{userName});
        for (ODocument result : results) {
            if (Collections.disjoint(this.readEntity((OIdentifiable)result).getPrincipals().getRealmNames(), realms)) continue;
            result.delete();
            return true;
        }
        return false;
    }

    public boolean deleteByUserName(ODatabaseDocumentTx db, String userName) {
        List results = (List)db.command((OCommandRequest)new OSQLSynchQuery(GET_USERNAME_QUERY)).execute(new Object[]{userName});
        boolean atLeastOneDeleted = false;
        for (ODocument result : results) {
            result.delete();
            atLeastOneDeleted = true;
        }
        return atLeastOneDeleted;
    }

    public boolean deleteByNameCode(ODatabaseDocumentTx db, String nameCode) {
        return this.deleteByNameCode.execute(db, new Object[]{nameCode});
    }

    public Iterable<OrientUserTokenRecord> getByExpiration(ODatabaseDocumentTx db, OffsetDateTime expiration) {
        ImmutableMap params = ImmutableMap.of((Object)P_EXPIRED_TIME, (Object)expiration.toInstant().toEpochMilli());
        List result = (List)db.command((OCommandRequest)new OSQLSynchQuery(EXPIRED_QUERY_STRING)).execute(new Object[]{params});
        if (result != null) {
            return result.stream().map(this::readEntity).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

