/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.legacy.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.sonatype.nexus.usertoken.plugin.UserToken;
import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.UserTokenService;
import com.sonatype.nexus.usertoken.plugin.encoding.EncodingStrategy;
import com.sonatype.nexus.usertoken.plugin.encoding.NameCodeGenerator;
import com.sonatype.nexus.usertoken.plugin.encoding.PassCodeGenerator;
import com.sonatype.nexus.usertoken.plugin.helper.UserTokenHelper;
import com.sonatype.nexus.usertoken.plugin.internal.UserNameHelper;
import com.sonatype.nexus.usertoken.plugin.internal.UserTokenCapabilityConfiguration;
import com.sonatype.nexus.usertoken.plugin.internal.UserTokenCapabilityDescriptor;
import com.sonatype.nexus.usertoken.plugin.legacy.store.UserTokenStore;
import com.sonatype.nexus.usertoken.plugin.rest.model.exportimport.UserTokenRecordXO;
import com.sonatype.nexus.usertoken.plugin.store.DuplicateUserTokenException;
import java.security.SecureRandom;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.sonatype.nexus.capability.CapabilityContext;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.crypto.CryptoHelper;
import org.sonatype.nexus.security.NexusSimplePrincipalCollection;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.security.UserPrincipalsHelper;
import org.sonatype.nexus.security.realm.RealmManager;
import org.sonatype.nexus.security.user.UserNotFoundException;

@Named
@Singleton
public class UserTokenServiceImpl
extends StateGuardLifecycleSupport
implements UserTokenService {
    private static final String CPREFIX = "${usertoken.userTokenServiceImpl";
    private final SecurityHelper securityHelper;
    private final RealmManager realmManager;
    private final UserPrincipalsHelper principalsHelper;
    private final UserTokenStore store;
    private final SecureRandom random;
    private final CapabilityRegistry capabilities;
    private final Provider<EncodingStrategy> encodingStrategy;
    private final NameCodeGenerator nameCodeGenerator;
    private final PassCodeGenerator passCodeGenerator;
    private final int maximumUniqueNameCodeAttempts;
    private AtomicBoolean protectContent = new AtomicBoolean(false);

    @Inject
    public UserTokenServiceImpl(SecurityHelper securityHelper, RealmManager realmManager, UserPrincipalsHelper principalsHelper, CryptoHelper crypto, CapabilityRegistry capabilities, UserTokenStore store, Provider<EncodingStrategy> encodingStrategy, NameCodeGenerator nameCodeGenerator, PassCodeGenerator passCodeGenerator, @Named(value="${usertoken.userTokenServiceImpl.maximumUniqueNameCodeAttempts:-10}") @Named(value="${usertoken.userTokenServiceImpl.maximumUniqueNameCodeAttempts:-10}") int maximumUniqueNameCodeAttempts) {
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
        this.realmManager = (RealmManager)Preconditions.checkNotNull((Object)realmManager);
        this.principalsHelper = (UserPrincipalsHelper)Preconditions.checkNotNull((Object)principalsHelper);
        this.capabilities = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilities);
        this.store = (UserTokenStore)Preconditions.checkNotNull((Object)store);
        this.random = ((CryptoHelper)Preconditions.checkNotNull((Object)crypto)).createSecureRandom();
        this.encodingStrategy = (Provider)Preconditions.checkNotNull(encodingStrategy);
        this.nameCodeGenerator = (NameCodeGenerator)Preconditions.checkNotNull((Object)nameCodeGenerator);
        this.passCodeGenerator = (PassCodeGenerator)Preconditions.checkNotNull((Object)passCodeGenerator);
        Preconditions.checkArgument((maximumUniqueNameCodeAttempts > 0 ? 1 : 0) != 0);
        this.maximumUniqueNameCodeAttempts = maximumUniqueNameCodeAttempts;
        this.log.debug("Maximum unique name-code attempts: {}", (Object)maximumUniqueNameCodeAttempts);
    }

    private CapabilityReference capabilityReference() {
        Collection refs = this.capabilities.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(UserTokenCapabilityDescriptor.TYPE));
        Preconditions.checkState((!refs.isEmpty() ? 1 : 0) != 0, (Object)"User-token capability has been removed");
        return (CapabilityReference)refs.iterator().next();
    }

    @Override
    public boolean isExpirationEnabled() {
        return Boolean.parseBoolean((String)this.capabilityReference().context().properties().get("expirationEnabled"));
    }

    @Override
    public void setExpirationEnabled(boolean enable) {
        if (this.isExpirationEnabled() == enable) {
            return;
        }
        CapabilityContext cctx = this.capabilityReference().context();
        UserTokenCapabilityConfiguration config = new UserTokenCapabilityConfiguration(cctx.properties());
        config.setExpirationEnabled(enable);
        try {
            this.capabilities.update(cctx.id(), cctx.isEnabled(), cctx.notes(), config.asMap());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Optional<Integer> getExpirationDays() {
        String expirationTimeString = (String)this.capabilityReference().context().properties().get("expirationDays");
        if (expirationTimeString == null || expirationTimeString.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Integer.parseInt(expirationTimeString));
    }

    @Override
    public Optional<Long> calculateExpirationTimestamp() {
        UserTokenRecord userTokenRecord = this.getCurrentUserToken();
        if (userTokenRecord == null) {
            return Optional.empty();
        }
        int expirationDays = this.getExpirationDaysWithValidation();
        return Optional.of(UserTokenHelper.getExpirationTimeStamp(userTokenRecord, expirationDays));
    }

    @Override
    public void setExpirationDays(int expirationDays) {
        if (this.getExpirationDays().orElse(0) == expirationDays) {
            return;
        }
        CapabilityContext cctx = this.capabilityReference().context();
        UserTokenCapabilityConfiguration config = new UserTokenCapabilityConfiguration(cctx.properties());
        config.setExpirationDays(expirationDays);
        try {
            this.capabilities.update(cctx.id(), cctx.isEnabled(), cctx.notes(), config.asMap());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.capabilities.get(this.capabilityReference().context().id()).context().isEnabled();
    }

    @Override
    public void setEnabled(boolean enable) {
        this.log.debug("Enabled: {}", (Object)enable);
        try {
            if (enable) {
                this.capabilities.enable(this.capabilityReference().context().id());
            } else {
                this.capabilities.disable(this.capabilityReference().context().id());
            }
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void ensureEnabled() {
        Preconditions.checkState((boolean)this.isEnabled(), (Object)"User-token feature is not enabled");
    }

    @Override
    public boolean isProtectContent() {
        return this.protectContent.get();
    }

    @Override
    public void setProtectContent(boolean enable) {
        if (this.isProtectContent() != enable) {
            CapabilityContext cctx = this.capabilityReference().context();
            UserTokenCapabilityConfiguration config = new UserTokenCapabilityConfiguration(cctx.properties());
            config.setProtectContent(enable);
            try {
                this.capabilities.update(cctx.id(), cctx.isEnabled(), cctx.notes(), config.asMap());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean isRealmConfigured() {
        return this.realmManager.isRealmEnabled("User-Token-Realm");
    }

    private void maybeConfigureRealm() throws Exception {
        this.realmManager.enableRealm("User-Token-Realm", 0);
    }

    @Override
    public EncodingStrategy getEncodingStrategy() {
        return (EncodingStrategy)this.encodingStrategy.get();
    }

    @Override
    public int getRecordCount() {
        return this.store.size();
    }

    protected void doStart() throws Exception {
        if (!EventHelper.isReplicating()) {
            this.maybeConfigureRealm();
        }
        UserTokenCapabilityConfiguration config = new UserTokenCapabilityConfiguration(this.capabilityReference().context().properties());
        this.log.debug("Protect content: {}", (Object)config.isProtectContent());
        this.protectContent.set(config.isProtectContent());
    }

    protected void doStop() throws Exception {
        this.protectContent.set(false);
    }

    @Override
    public UserTokenRecord current(boolean create) {
        this.ensureEnabled();
        PrincipalCollection principals = this.securityHelper.subject().getPrincipals();
        String userName = UserTokenServiceImpl.getUserName(principals);
        UserTokenRecord record = this.doGet(userName, principals.getRealmNames());
        if (this.isExpired(record)) {
            return null;
        }
        if (record == null && create) {
            record = this.create(principals);
        }
        return record;
    }

    private static String getUserName(PrincipalCollection principals) {
        String userName = UserNameHelper.get(principals);
        if (principals instanceof NexusSimplePrincipalCollection) {
            NexusSimplePrincipalCollection nexusSimplePrincipalCollection = (NexusSimplePrincipalCollection)principals;
            return nexusSimplePrincipalCollection.isRealmCaseSensitive() ? userName : userName.toLowerCase();
        }
        return userName;
    }

    @Override
    public UserTokenRecord get(String userName, String realm) {
        this.ensureEnabled();
        return this.doGet(userName, realm);
    }

    @Override
    public List<UserTokenRecord> get(@Nullable Date since) {
        this.ensureEnabled();
        return this.store.get(since);
    }

    private UserTokenRecord doGet(String userName, String realm) {
        Preconditions.checkNotNull((Object)userName);
        Preconditions.checkNotNull((Object)realm);
        this.log.debug("Getting record for: {} and realm {}", (Object)userName, (Object)realm);
        return this.store.get(userName, realm);
    }

    private UserTokenRecord doGet(String userName, Set<String> realms) {
        Preconditions.checkNotNull((Object)userName);
        Preconditions.checkNotNull(realms);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting record for: {} and any of the realms {}", (Object)userName, (Object)String.join((CharSequence)",", realms));
        }
        return this.store.get(userName, realms);
    }

    private String createNameCode(String userName) {
        try {
            String tmp = String.valueOf(userName) + "#" + this.random.nextLong();
            return this.nameCodeGenerator.generate((EncodingStrategy)this.encodingStrategy.get(), tmp);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private char[] createPassCode() {
        try {
            return this.passCodeGenerator.generate((EncodingStrategy)this.encodingStrategy.get());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public UserTokenRecord create(PrincipalCollection principals) {
        Preconditions.checkNotNull((Object)principals);
        this.ensureEnabled();
        this.log.debug("Creating user-token record for: {}", (Object)principals);
        char[] passCode = this.createPassCode();
        String userName = UserNameHelper.get(principals);
        int count = 0;
        while (true) {
            String nameCode = this.createNameCode(userName);
            try {
                UserToken token = new UserToken(nameCode, passCode);
                UserTokenRecord record = this.store.newUserTokenRecord(principals, token);
                this.store.add(record);
                this.log.debug("Added record mapping: {} -> {}", (Object)userName, (Object)nameCode);
                return record;
            }
            catch (DuplicateUserTokenException duplicateUserTokenException) {
                Preconditions.checkState((++count <= this.maximumUniqueNameCodeAttempts ? 1 : 0) != 0, (String)"Failed to create user-token record; giving up after %s attempts", (int)count);
                this.log.debug("Detected name-code collision for '{}'; retrying", (Object)nameCode);
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            break;
        }
    }

    @Override
    public void insert(UserTokenRecordXO userTokenRecordXO, boolean overwrite) throws DuplicateUserTokenException {
        UserToken token = new UserToken(userTokenRecordXO.getNameCode(), userTokenRecordXO.getPassCode());
        SimplePrincipalCollection principals = new SimplePrincipalCollection();
        userTokenRecordXO.getPrincipalCollection().keySet().forEach(realmName -> userTokenRecordXO.getPrincipalCollection().get(realmName).forEach(principal -> principals.add(principal, realmName)));
        UserTokenRecord record = this.store.newUserTokenRecord((PrincipalCollection)principals, token, userTokenRecordXO.getCreated());
        if (overwrite) {
            this.store.addOrReplace(record);
            this.log.debug("Added/replaced usertoken record for principal {}", (Object)record.getUserName());
        } else {
            this.store.add(record);
            this.log.debug("Added usertoken record for principal {}", (Object)record.getUserName());
        }
    }

    @Override
    public void remove(String userName, String realm) {
        Preconditions.checkNotNull((Object)userName);
        Preconditions.checkNotNull((Object)realm);
        this.ensureEnabled();
        this.log.debug("Removing record for: {} and source {}", (Object)userName, (Object)realm);
        this.store.remove(userName, realm);
    }

    @Override
    public void remove(String userName, Set<String> realms) {
        Preconditions.checkNotNull((Object)userName);
        Preconditions.checkNotNull(realms);
        this.ensureEnabled();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing record for: userId {} and realms {}", (Object)userName, (Object)String.join((CharSequence)",", realms));
        }
        this.store.remove(userName, realms);
    }

    @Override
    public void removeAll() {
        this.log.info("Removing all records");
        this.ensureEnabled();
        this.store.clear();
    }

    @Override
    public void removeInvalid() {
        this.log.debug("Removing invalid records");
        this.ensureEnabled();
        int count = 0;
        for (UserTokenRecord record : this.store.records()) {
            try {
                this.principalsHelper.getUserStatus(record.getPrincipals());
            }
            catch (UserNotFoundException userNotFoundException) {
                this.remove(record.getUserName(), record.getPrincipals().getRealmNames());
                ++count;
            }
        }
        this.log.debug("Removed {} invalid records", (Object)count);
    }

    @Override
    public boolean isExpired(UserTokenRecord tokenRecord) {
        if (this.isExpirationEnabled() && tokenRecord != null) {
            int expirationDays = this.getExpirationDaysWithValidation();
            return UserTokenHelper.isTokenExpired(tokenRecord, expirationDays);
        }
        return false;
    }

    @Override
    public UserTokenRecord create() {
        this.ensureEnabled();
        PrincipalCollection principals = this.securityHelper.subject().getPrincipals();
        String userName = UserTokenServiceImpl.getUserName(principals);
        UserTokenRecord record = this.doGet(userName, principals.getRealmNames());
        if (record != null) {
            this.remove(userName, principals.getRealmNames());
        }
        this.create(principals);
        return record;
    }

    private Integer getExpirationDaysWithValidation() {
        return this.getExpirationDays().orElseThrow(() -> new IllegalStateException("User Token Expiration is enabled, but Expiration Days value is missing"));
    }

    @Override
    public UserTokenRecord getByUserToken(UserToken token) {
        UserTokenRecord record = this.store.get(token.getNameCode());
        if (record != null && Arrays.equals(record.getPassCode(), token.getPassCode())) {
            return record;
        }
        return null;
    }

    @Override
    public void remove(PrincipalCollection principal) {
        String userName = UserNameHelper.get(principal);
        this.remove(userName, principal.getRealmNames());
    }

    @Override
    public void cleanup() {
        this.log.debug("Cleaning up expired tokens legacy.");
        if (!this.isExpirationEnabled()) {
            this.log.debug("User token expiration disabled.");
            return;
        }
        Optional<Integer> expiration = this.getExpirationDays();
        if (!expiration.isPresent()) {
            this.log.debug("User token expiration in days not set.");
            return;
        }
        OffsetDateTime expirationDate = OffsetDateTime.now().minusDays(expiration.get().intValue());
        this.store.remove(expirationDate);
    }

    public UserTokenRecord getCurrentUserToken() {
        this.ensureEnabled();
        PrincipalCollection principals = this.securityHelper.subject().getPrincipals();
        String userName = UserTokenServiceImpl.getUserName(principals);
        return this.doGet(userName, principals.getRealmNames());
    }
}

