/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.internal.task;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Cron;
import org.sonatype.nexus.scheduling.schedule.Schedule;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class UserTokenCleanupTaskManager
extends StateGuardLifecycleSupport {
    private final TaskScheduler taskScheduler;
    private final String cleanupCron;
    private final Predicate<TaskInfo> isCleaningUserTokenTask = info -> "usertoken.cleanup".equals(info.getConfiguration().getTypeId());

    @Inject
    public UserTokenCleanupTaskManager(TaskScheduler taskScheduler, @Named(value="${nexus.usertoken.cleanup.cron:-0 1 2 * * ?}") @Named(value="${nexus.usertoken.cleanup.cron:-0 1 2 * * ?}") String cleanupCron) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.cleanupCron = (String)Preconditions.checkNotNull((Object)cleanupCron);
    }

    protected void doStart() throws Exception {
        this.removeExistingTasks();
        TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("usertoken.cleanup");
        configuration.setName("Admin - Cleanup expired user tokens");
        Cron schedule = this.taskScheduler.getScheduleFactory().cron(new Date(), this.cleanupCron);
        this.taskScheduler.scheduleTask(configuration, (Schedule)schedule);
    }

    private void removeExistingTasks() {
        this.taskScheduler.listsTasks().stream().filter(this.isCleaningUserTokenTask).forEach(TaskInfo::remove);
    }
}

