/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.internal;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.config.MemorySecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityContributor;
import org.sonatype.nexus.security.config.SecurityContributorSupport;

@Named
@Singleton
public class UserTokenSecurityContributor
extends SecurityContributorSupport
implements SecurityContributor {
    public static final String USERTOKEN_CURRENT_DOMAIN = "usertoken-current";
    public static final String USERTOKEN_USER_DOMAIN = "usertoken-user";
    public static final String USERTOKEN_USERS_DOMAIN = "usertoken-users";
    public static final String USERTOKEN_SETTINGS_DOMAIN = "usertoken-settings";
    public static final String USERTOKEN_CURRENT_PRIV_ID = "nx-usertoken-current";
    public static final String USERTOKEN_CURRENT_PRIV_DESCRIPTION = "All permissions for Current User Token";
    public static final String USERTOKEN_USER_RESET_PRIV_ID = "nx-usertoken-user";
    public static final String USERTOKEN_USER_RESET_PRIV_DESCRIPTION = "Reset permission for User Token";
    public static final String USERTOKEN_USER_RESET_ALL_PRIV_ID = "nx-usertoken-users";
    public static final String USERTOKEN_USER_RESET_ALL_PRIV_DESCRIPTION = "Reset permission for all User Tokens";
    public static final String USERTOKEN_SETTINGS_UPDATE_PRIV_ID = "nx-usertoken-settings";
    public static final String USERTOKEN_SETTINGS_UPDATE_PRIV_DESCRIPTION = "Update permission for User Token settings";
    public static final String ACTION_CURRENT = String.join((CharSequence)",", "create", "read", "delete");

    public SecurityConfiguration getContribution() {
        MemorySecurityConfiguration config = new MemorySecurityConfiguration();
        config.addPrivilege((CPrivilege)this.createApplicationPrivilege(USERTOKEN_CURRENT_PRIV_ID, USERTOKEN_CURRENT_PRIV_DESCRIPTION, USERTOKEN_CURRENT_DOMAIN, ACTION_CURRENT));
        config.addPrivilege((CPrivilege)this.createApplicationPrivilege(USERTOKEN_USER_RESET_PRIV_ID, USERTOKEN_USER_RESET_PRIV_DESCRIPTION, USERTOKEN_USER_DOMAIN, "delete,read"));
        config.addPrivilege((CPrivilege)this.createApplicationPrivilege(USERTOKEN_USER_RESET_ALL_PRIV_ID, USERTOKEN_USER_RESET_ALL_PRIV_DESCRIPTION, USERTOKEN_USERS_DOMAIN, "delete"));
        config.addPrivilege((CPrivilege)this.createApplicationPrivilege(USERTOKEN_SETTINGS_UPDATE_PRIV_ID, USERTOKEN_SETTINGS_UPDATE_PRIV_DESCRIPTION, USERTOKEN_SETTINGS_DOMAIN, "update,read"));
        return config;
    }
}

