/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.internal;

import com.sonatype.nexus.usertoken.plugin.internal.UserTokenCapabilityConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.capability.CapabilityDescriptorSupport;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.Tag;
import org.sonatype.nexus.capability.Taggable;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.formfields.CheckboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.NumberTextFormField;

@AvailabilityVersion(from="1.0")
@Named(value="usertoken")
@Singleton
public class UserTokenCapabilityDescriptor
extends CapabilityDescriptorSupport<UserTokenCapabilityConfiguration>
implements Taggable {
    public static final String TYPE_ID = "usertoken";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"usertoken");
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final FormField<Boolean> protectContent;
    private final FormField<Boolean> expirationEnabled;
    private final FormField<Number> expirationDays;

    public UserTokenCapabilityDescriptor() {
        this.setExposed(true);
        this.setHidden(true);
        this.protectContent = new CheckboxFormField("protectContent", messages.protectContentLabel(), messages.protectContentHelp(), false).withInitialValue(Boolean.valueOf(false));
        this.expirationEnabled = new CheckboxFormField("expirationEnabled", messages.expirationEnabledLabel(), messages.expirationEnabledHelp(), false).withInitialValue(Boolean.valueOf(false));
        this.expirationDays = new NumberTextFormField("expirationDays", messages.expirationDaysLabel(), String.format("%s (e.g., %s-%s. Default: %s days)", messages.expirationDaysHelp(), 1, 999, 30), false).withInitialValue((Number)30).withMinimumValue((Number)1).withMaximumValue((Number)999);
    }

    public CapabilityType type() {
        return TYPE;
    }

    public String name() {
        return messages.name();
    }

    public List<FormField> formFields() {
        return Arrays.asList(this.protectContent, this.expirationEnabled, this.expirationDays);
    }

    protected UserTokenCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new UserTokenCapabilityConfiguration(properties);
    }

    protected String renderAbout() throws Exception {
        return this.render("usertoken-about.vm");
    }

    public Set<Tag> getTags() {
        return Tag.tags((Tag[])new Tag[]{Tag.categoryTag((String)"Security")});
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="User Token")
        public String name();

        @MessageBundle.DefaultMessage(value="Protect Content")
        public String protectContentLabel();

        @MessageBundle.DefaultMessage(value="Select this option to require that user tokens are used for repository authentication. This does not affect UI access.")
        public String protectContentHelp();

        @MessageBundle.DefaultMessage(value="Expiration Enabled")
        public String expirationEnabledLabel();

        @MessageBundle.DefaultMessage(value="Select this option to enable token expiration.")
        public String expirationEnabledHelp();

        @MessageBundle.DefaultMessage(value="Expiration Days")
        public String expirationDaysLabel();

        @MessageBundle.DefaultMessage(value="Set the expiration days for the user token.")
        public String expirationDaysHelp();
    }
}

