/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.sonatype.nexus.capability.CapabilityConfigurationSupport;

public class UserTokenCapabilityConfiguration
extends CapabilityConfigurationSupport {
    public static final String PROTECT_CONTENT = "protectContent";
    public static final String EXPIRATION_ENABLED = "expirationEnabled";
    public static final String EXPIRATION_DAYS = "expirationDays";
    public static final boolean DEFAULT_PROTECT_CONTENT = false;
    public static final boolean DEFAULT_EXPIRATION_ENABLED = false;
    public static final int DEFAULT_EXPIRATION_DAYS = 30;
    public static final int MINIMUM_EXPIRATION_DAYS = 1;
    public static final int MAXIMUM_EXPIRATION_DAYS = 999;
    private boolean protectContent;
    private boolean expirationEnabled;
    private int expirationDays;

    public UserTokenCapabilityConfiguration(Map<String, String> properties) {
        Preconditions.checkNotNull(properties);
        this.protectContent = this.parseBoolean(properties.get(PROTECT_CONTENT), false);
        this.expirationEnabled = this.parseBoolean(properties.get(EXPIRATION_ENABLED), false);
        this.expirationDays = this.parseInteger(properties.get(EXPIRATION_DAYS), 30);
        if (this.expirationEnabled && properties.get(EXPIRATION_DAYS).isEmpty()) {
            properties.put(EXPIRATION_DAYS, String.valueOf(30));
        }
    }

    public boolean isProtectContent() {
        return this.protectContent;
    }

    public UserTokenCapabilityConfiguration setProtectContent(boolean protectContent) {
        this.protectContent = protectContent;
        return this;
    }

    public boolean isExpirationEnabled() {
        return this.expirationEnabled;
    }

    public UserTokenCapabilityConfiguration setExpirationEnabled(boolean expirationEnabled) {
        this.expirationEnabled = expirationEnabled;
        return this;
    }

    public int getExpirationDays() {
        return this.expirationDays;
    }

    public UserTokenCapabilityConfiguration setExpirationDays(int expirationDays) {
        this.expirationDays = expirationDays;
        return this;
    }

    public Map<String, String> asMap() {
        HashMap props = Maps.newHashMap();
        props.put(PROTECT_CONTENT, String.valueOf(this.protectContent));
        props.put(EXPIRATION_ENABLED, String.valueOf(this.expirationEnabled));
        props.put(EXPIRATION_DAYS, String.valueOf(this.expirationDays));
        return props;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "protectContent=" + this.protectContent + ", " + "expirationEnabled=" + this.expirationEnabled + ", " + "expirationDays=" + this.expirationDays + '}';
    }
}

