/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.helper;

import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import java.time.Instant;

public class UserTokenHelper {
    public static final long MILLISECONDS_IN_ONE_DAY = 86400000L;

    private UserTokenHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isTokenExpired(UserTokenRecord userTokenRecord, int expirationDays) {
        long expiration = UserTokenHelper.getExpirationTimeStamp(userTokenRecord, expirationDays);
        return Instant.now().toEpochMilli() > expiration;
    }

    public static long getExpirationTimeStamp(UserTokenRecord userToken, int expirationDays) {
        return 86400000L * (long)expirationDays + userToken.getCreated().getTime();
    }
}

