/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.encoding;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.usertoken.plugin.encoding.EncodingStrategy;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;

@Named
@Singleton
public class EncodingStrategyProvider
extends ComponentSupport
implements Provider<EncodingStrategy> {
    private static final String CPREFIX = "${usertoken.encodingStrategyProvider";
    private final Map<String, EncodingStrategy> strategies;
    private final String strategyId;
    private final EncodingStrategy defaultStrategy;
    private EncodingStrategy strategy;

    @Inject
    public EncodingStrategyProvider(Map<String, EncodingStrategy> strategies, @Nullable @Named(value="${usertoken.encodingStrategyProvider.strategy}") @Nullable @Named(value="${usertoken.encodingStrategyProvider.strategy}") String strategyId, @Named(value="default") @Named(value="default") EncodingStrategy defaultStrategy) {
        this.strategies = (Map)Preconditions.checkNotNull(strategies);
        this.strategyId = strategyId;
        this.defaultStrategy = (EncodingStrategy)Preconditions.checkNotNull((Object)defaultStrategy);
    }

    public EncodingStrategy get() {
        if (this.strategy == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Strategies:");
                for (Map.Entry<String, EncodingStrategy> entry : this.strategies.entrySet()) {
                    this.log.debug("  {}", (Object)entry.getKey());
                }
            }
            EncodingStrategy tmp = null;
            if (this.strategyId != null) {
                this.log.debug("Selecting strategy for ID: {}", (Object)this.strategyId);
                EncodingStrategy found = this.strategies.get(this.strategyId);
                if (found != null) {
                    tmp = found;
                } else {
                    this.log.error("No strategy bound for: {}", (Object)this.strategyId);
                }
            }
            if (tmp == null) {
                this.log.debug("Using default strategy: {}", (Object)this.defaultStrategy);
                this.strategy = this.defaultStrategy;
            } else {
                this.strategy = tmp;
                this.log.debug("Strategy: {}", (Object)this.strategy);
            }
        }
        return this.strategy;
    }
}

