/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.encoding;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.sonatype.nexus.usertoken.plugin.encoding.EncodingStrategy;
import org.sonatype.goodies.common.ComponentSupport;

public abstract class Base64EncodingStrategySupport
extends ComponentSupport
implements EncodingStrategy {
    private int base64Length(int bytes) {
        return bytes * 4 / 3;
    }

    @Override
    public int getNameCodeLength() {
        return this.base64Length(this.getNameCodeByteSize());
    }

    @Override
    public String encodeNameCodeBytes(byte[] bytes) {
        Preconditions.checkNotNull((Object)bytes);
        Preconditions.checkArgument((bytes.length > 0 ? 1 : 0) != 0);
        return BaseEncoding.base64Url().encode(bytes);
    }

    @Override
    public int getPassCodeLength() {
        return this.base64Length(this.getPassCodeByteSize());
    }

    @Override
    public String encodePassCodeBytes(byte[] bytes) {
        Preconditions.checkNotNull((Object)bytes);
        Preconditions.checkArgument((bytes.length > 0 ? 1 : 0) != 0);
        return BaseEncoding.base64Url().encode(bytes);
    }

    public String toString() {
        return String.format("%s-%s+Base64", this.getNameCodeByteSize(), this.getPassCodeByteSize());
    }
}

