/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.datastore;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.apikey.store.UserTokenStore;
import com.sonatype.nexus.usertoken.plugin.legacy.store.internal.UserTokenStoreImpl;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.upgrade.datastore.RepeatableDatabaseMigrationStep;

@Named
@Singleton
public class UserTokenToApiKeyMigrationStep
extends RepeatableDatabaseMigrationStep {
    private static final String GET_LOCAL_USERNAMES_QUERY = "SELECT user_id FROM user_role_mapping WHERE source = 'default'";
    private final UserTokenStore userTokenStore;
    private final UserTokenStoreImpl legacyStore;

    @Inject
    public UserTokenToApiKeyMigrationStep(UserTokenStore userTokenStore, UserTokenStoreImpl legacyStore) {
        this.userTokenStore = (UserTokenStore)Preconditions.checkNotNull((Object)userTokenStore);
        this.legacyStore = (UserTokenStoreImpl)Preconditions.checkNotNull((Object)legacyStore);
    }

    public void migrate(Connection connection) throws Exception {
        if (this.tableExists(connection, "user_token") && !this.alreadyMigrated(connection)) {
            this.log.info("Beginning migration of user token data");
            ArrayList<UserTokenRecord> records = new ArrayList<UserTokenRecord>(this.legacyStore.records());
            int available = records.size();
            AtomicInteger count = new AtomicInteger();
            this.removeDuplicateTokens(connection, records).peek(__ -> {
                int n = count.incrementAndGet();
            }).forEach(this.userTokenStore::addOrReplace);
            int migratedCount = count.get();
            this.log.info("Migrated {} user token records, removed {} duplicates", (Object)migratedCount, (Object)(available - migratedCount));
        }
    }

    private boolean alreadyMigrated(Connection connection) throws Exception {
        return this.userTokenStore.records().size() > 0;
    }

    private Stream<UserTokenRecord> removeDuplicateTokens(Connection connection, Collection<UserTokenRecord> records) throws SQLException {
        List<String> userIds = this.getUserIds(connection);
        this.log.debug("Found local users: {}", userIds);
        Set<String> duplicates = UserTokenToApiKeyMigrationStep.findCaseDifferingNames(userIds);
        this.log.debug("Found duplicate names : {}", duplicates);
        return records.stream().filter(record -> {
            if (!record.getPrincipals().getRealmNames().contains("default")) {
                return true;
            }
            return !duplicates.contains(record.getUserName().toLowerCase());
        });
    }

    private List<String> getUserIds(Connection connection) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement st = connection.createStatement();){
            ResultSet rs = st.executeQuery(GET_LOCAL_USERNAMES_QUERY);
            ArrayList<String> userIds = new ArrayList<String>();
            while (rs.next()) {
                userIds.add(rs.getString("user_id"));
            }
            return userIds;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Set<String> findCaseDifferingNames(List<String> names) {
        return names.stream().collect(Collectors.groupingBy(name -> name.toLowerCase())).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Integer getChecksum() {
        return 2;
    }
}

