/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.datastore;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.apikey.store.UserTokenStore;
import com.sonatype.nexus.usertoken.plugin.datastore.UserTokenToApiKeyMigrationStep;
import com.sonatype.nexus.usertoken.plugin.task.LdapSamlDualRealmUserTokensUtil;
import java.sql.Connection;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.UpgradeTaskScheduler;
import org.sonatype.nexus.upgrade.datastore.DependsOn;
import org.sonatype.nexus.upgrade.datastore.RepeatableDatabaseMigrationStep;

@DependsOn(value=UserTokenToApiKeyMigrationStep.class)
@Named
@Singleton
public class UserTokenLdapSamlDualRealmUserTokensMigrationStep
extends RepeatableDatabaseMigrationStep {
    private final UserTokenStore userTokenStore;
    private final UpgradeTaskScheduler scheduler;
    private final TaskScheduler taskScheduler;

    @Inject
    public UserTokenLdapSamlDualRealmUserTokensMigrationStep(UserTokenStore userTokenStore, UpgradeTaskScheduler scheduler, TaskScheduler taskScheduler) {
        this.userTokenStore = (UserTokenStore)Preconditions.checkNotNull((Object)userTokenStore);
        this.scheduler = (UpgradeTaskScheduler)Preconditions.checkNotNull((Object)scheduler);
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
    }

    public Integer getChecksum() {
        return 1;
    }

    public void migrate(Connection connection) throws Exception {
        if (!this.hasDualRealmTokens()) {
            this.log.info("Found no user tokens with multiple realms realms.");
            return;
        }
        this.scheduleTask();
    }

    private void scheduleTask() {
        this.log.info("Scheduling task to fix user tokens with multiple realms.");
        this.scheduler.schedule(this.taskScheduler.createTaskConfigurationInstance("apikey.usertoken.ldapsamldualrealm.singlerealm"));
    }

    private boolean hasDualRealmTokens() {
        Collection<UserTokenRecord> userTokenRecords;
        int page = 1;
        int pageSize = 1000;
        do {
            userTokenRecords = this.userTokenStore.recordsPaginated(page++, pageSize);
            this.log.debug("Page {} contains {} records", (Object)page, (Object)userTokenRecords.size());
            if (!LdapSamlDualRealmUserTokensUtil.hasLdapSamlDualRealmUserTokens(userTokenRecords)) continue;
            this.log.debug("Found user tokens containing multiple realms on page {}", (Object)page);
            return true;
        } while (userTokenRecords.size() == pageSize);
        return false;
    }
}

