/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.datastore;

import java.sql.Connection;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.upgrade.datastore.RepeatableDatabaseMigrationStep;

@Named
@Singleton
public class UserTokenDatabaseMigrationStep
extends RepeatableDatabaseMigrationStep {
    private static final String TABLE_NAME = "USER_TOKEN";
    private static final String DROP_CONSTRAINTS_STATEMENT = "ALTER TABLE user_token DROP CONSTRAINT IF EXISTS pk_user_token_user_name;ALTER TABLE user_token DROP CONSTRAINT IF EXISTS pk_user_token_name_code;ALTER TABLE user_token DROP CONSTRAINT IF EXISTS uk_user_token_name_code;";
    private static final String ADD_PK_STATEMENT = "ALTER TABLE user_token ADD CONSTRAINT pk_user_token_name_code PRIMARY KEY (name_code);";
    private static final String ADD_INDEX_STATEMENT = "CREATE INDEX IF NOT EXISTS idx_user_token_user_name ON user_token(user_name);";

    public void migrate(Connection connection) throws Exception {
        if (!this.tableExists(connection, TABLE_NAME)) {
            this.log.info("Table {} does not exists. Upgrade step will be ignored.", (Object)TABLE_NAME);
            return;
        }
        this.runStatement(connection, DROP_CONSTRAINTS_STATEMENT);
        if (!this.indexExists(connection, "pk_user_token_name_code")) {
            this.runStatement(connection, ADD_PK_STATEMENT);
        }
        this.runStatement(connection, ADD_INDEX_STATEMENT);
        this.log.info("Table schema of {} has been updated.", (Object)TABLE_NAME);
    }

    public Integer getChecksum() {
        return 1;
    }
}

