/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.apikey.store.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.usertoken.plugin.UserToken;
import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.apikey.store.UserTokenStore;
import com.sonatype.nexus.usertoken.plugin.apikey.store.internal.UserTokenRecordData;
import com.sonatype.nexus.usertoken.plugin.store.DuplicateUserTokenException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.time.DateHelper;
import org.sonatype.nexus.datastore.api.DuplicateKeyException;
import org.sonatype.nexus.security.authc.apikey.ApiKey;
import org.sonatype.nexus.security.authc.apikey.ApiKeyStore;

@Named(value="default")
@Singleton
public class UserTokenStoreImpl
extends ComponentSupport
implements UserTokenStore {
    public static final String DOMAIN = "User-Token-Realm";
    private ApiKeyStore apiKeyStore;

    @Inject
    public UserTokenStoreImpl(ApiKeyStore apiKeyStore) {
        this.apiKeyStore = (ApiKeyStore)Preconditions.checkNotNull((Object)apiKeyStore);
    }

    @Override
    public UserTokenRecord newUserTokenRecord(PrincipalCollection principals, UserToken token, OffsetDateTime created) {
        return new UserTokenRecordData(principals, token, created);
    }

    @Override
    public void add(UserTokenRecord record) throws DuplicateUserTokenException {
        if (this.apiKeyStore.getApiKey(DOMAIN, record.getPrincipals()).isPresent()) {
            this.log.debug("Skipping {} as token exists", (Object)record.getPrincipals());
            throw new DuplicateUserTokenException(record.getPrincipals().toString());
        }
        try {
            this.apiKeyStore.persistApiKey(DOMAIN, record.getPrincipals(), UserTokenStoreImpl.encode(record.getUserToken()), DateHelper.toOffsetDateTime((Date)record.getCreated()));
        }
        catch (DuplicateKeyException duplicateKeyException) {
            throw new DuplicateUserTokenException(record.toString());
        }
    }

    @Override
    public void addOrReplace(UserTokenRecord record) {
        this.apiKeyStore.deleteApiKey(DOMAIN, record.getPrincipals());
        this.apiKeyStore.persistApiKey(DOMAIN, record.getPrincipals(), UserTokenStoreImpl.encode(record.getUserToken()), DateHelper.toOffsetDateTime((Date)record.getCreated()));
    }

    @Override
    public List<UserTokenRecord> get(OffsetDateTime createdSince) {
        if (createdSince == null) {
            return (List)this.records();
        }
        return this.apiKeyStore.browseByCreatedDate(DOMAIN, createdSince).stream().map(UserTokenStoreImpl::convert).collect(Collectors.toList());
    }

    @Override
    public Collection<UserTokenRecord> records() {
        return this.apiKeyStore.browse(DOMAIN).stream().map(UserTokenStoreImpl::convert).collect(Collectors.toList());
    }

    @Override
    public UserTokenRecord get(String userName, String realm) {
        return this.apiKeyStore.getApiKey(DOMAIN, (PrincipalCollection)new SimplePrincipalCollection((Object)userName, realm)).map(UserTokenStoreImpl::convert).orElse(null);
    }

    @Override
    public UserTokenRecord get(PrincipalCollection principals) {
        return this.apiKeyStore.getApiKey(DOMAIN, principals).map(UserTokenStoreImpl::convert).orElse(null);
    }

    @Override
    public int size() {
        return this.apiKeyStore.count(DOMAIN);
    }

    @Override
    public UserTokenRecord newUserTokenRecord(PrincipalCollection principals, UserToken token) {
        return new UserTokenRecordData(principals, token, new Date());
    }

    @Override
    public void remove(String userName, String realm) {
        this.apiKeyStore.deleteApiKey(DOMAIN, (PrincipalCollection)new SimplePrincipalCollection((Object)userName, realm));
    }

    @Override
    public void remove(String userName, Set<String> realms) {
        realms.stream().forEach(realm -> this.remove(userName, (String)realm));
    }

    @Override
    public void remove(PrincipalCollection principal) {
        this.apiKeyStore.deleteApiKey(DOMAIN, principal);
    }

    @Override
    public void clear() {
        this.apiKeyStore.deleteApiKeys(DOMAIN);
    }

    @Override
    public UserTokenRecord getByUserToken(UserToken token) {
        return this.apiKeyStore.getApiKeyByToken(DOMAIN, UserTokenStoreImpl.encode(token)).map(UserTokenStoreImpl::convert).orElse(null);
    }

    @Override
    public void remove(OffsetDateTime expiration) {
        this.apiKeyStore.deleteApiKeys(expiration);
    }

    @Override
    public void update(UserTokenRecord from, UserTokenRecord to) {
        ApiKey fromApiKey = this.apiKeyStore.getApiKey(DOMAIN, from.getPrincipals()).orElse(null);
        if (fromApiKey == null) {
            this.log.debug("User token not found. Not updating.");
            return;
        }
        ApiKey toApiKey = this.apiKeyStore.newApiKey(DOMAIN, to.getPrincipals(), UserTokenStoreImpl.encode(to.getUserToken()), DateHelper.toOffsetDateTime((Date)to.getCreated()));
        this.apiKeyStore.updateApiKey(fromApiKey, toApiKey);
    }

    @Override
    public Collection<UserTokenRecord> recordsPaginated(int page, int pageSize) {
        Preconditions.checkArgument((page > 0 ? 1 : 0) != 0, (Object)"page must be greater than 0");
        Preconditions.checkArgument((pageSize > 0 ? 1 : 0) != 0, (Object)"page size must be greater than 0");
        return this.apiKeyStore.browsePaginated(DOMAIN, page, pageSize).stream().map(UserTokenStoreImpl::convert).collect(Collectors.toList());
    }

    public static char[] encode(UserToken token) {
        String nameCode = token.getNameCode();
        char[] passCode = token.getPassCode();
        char[] apiKey = new char[nameCode.length() + token.getPassCode().length + 1];
        int startIndex = 0;
        System.arraycopy(nameCode.toCharArray(), 0, apiKey, startIndex, nameCode.length());
        startIndex += nameCode.length();
        apiKey[startIndex++] = 58;
        System.arraycopy(passCode, 0, apiKey, startIndex, passCode.length);
        return apiKey;
    }

    public static UserToken decode(char[] chars) {
        int index = -1;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == ':') {
                index = i;
                break;
            }
            ++i;
        }
        Preconditions.checkArgument((index != -1 ? 1 : 0) != 0, (Object)"Unable to decode token");
        String nameCode = new String(Arrays.copyOfRange(chars, 0, index));
        char[] passCode = Arrays.copyOfRange(chars, index + 1, chars.length);
        return new UserToken(nameCode, passCode);
    }

    private static UserTokenRecord convert(ApiKey apiKey) {
        return new UserTokenRecordData(apiKey.getPrincipals(), UserTokenStoreImpl.decode(apiKey.getApiKey()), apiKey.getCreated());
    }
}

