/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.api;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.usertoken.plugin.UserTokenService;
import com.sonatype.nexus.usertoken.plugin.api.UserTokensApiModel;
import com.sonatype.nexus.usertoken.plugin.api.UserTokensApiResourceDoc;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public abstract class UserTokensApiResource
extends ComponentSupport
implements Resource,
UserTokensApiResourceDoc {
    private final UserTokenService userTokens;

    @Inject
    public UserTokensApiResource(UserTokenService userTokens) {
        this.userTokens = (UserTokenService)Preconditions.checkNotNull((Object)userTokens);
    }

    @Override
    @DELETE
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:usertoken-users:delete"})
    public void resetAllUserTokens() {
        try {
            this.userTokens.removeAll();
        }
        catch (IllegalStateException illegalStateException) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)"\"User tokens are not enabled.\"", "application/json");
        }
    }

    @Override
    @GET
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:usertoken-settings:read"})
    public UserTokensApiModel serviceStatus() {
        return new UserTokensApiModel(this.userTokens.isEnabled(), this.userTokens.isProtectContent(), this.userTokens.isExpirationEnabled(), this.userTokens.getExpirationDays().orElse(30));
    }

    @Override
    @PUT
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:usertoken-settings:update"})
    public UserTokensApiModel setServiceStatus(@NotNull @Valid UserTokensApiModel model) {
        this.userTokens.setEnabled(model.isEnabled());
        this.userTokens.setProtectContent(model.isProtectContent());
        this.userTokens.setExpirationEnabled(model.isExpirationEnabled());
        this.userTokens.setExpirationDays(model.getExpirationDays());
        return new UserTokensApiModel(this.userTokens.isEnabled(), this.userTokens.isProtectContent(), this.userTokens.isExpirationEnabled(), this.userTokens.getExpirationDays().orElse(30));
    }
}

