/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.api;

import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

public class UserTokensApiModel {
    @ApiModelProperty(value="Whether or not User Tokens feature is enabled")
    private boolean enabled;
    @ApiModelProperty(value="Additionally require user tokens for repository authentication")
    private boolean protectContent;
    @ApiModelProperty(value="Enable user tokens expiration")
    private boolean expirationEnabled;
    @ApiModelProperty(value="Set user token expiration days (E.g., 1-999)", example="30")
    @Min(value=1L, message="the minimum value is 1")
    @Max(value=999L, message="the maximum value is 999")
    private @Min(value=1L, message="the minimum value is 1") @Max(value=999L, message="the maximum value is 999") int expirationDays;

    public UserTokensApiModel() {
    }

    public UserTokensApiModel(boolean enabled) {
        this(enabled, false);
    }

    public UserTokensApiModel(boolean enabled, boolean protectContent) {
        this(enabled, protectContent, false, 30);
    }

    public UserTokensApiModel(boolean enabled, boolean protectContent, boolean expirationEnabled, int expirationDays) {
        this.enabled = enabled;
        this.protectContent = protectContent;
        this.expirationEnabled = expirationEnabled;
        this.expirationDays = expirationDays;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isProtectContent() {
        return this.protectContent;
    }

    public void setProtectContent(boolean protectContent) {
        this.protectContent = protectContent;
    }

    public boolean isExpirationEnabled() {
        return this.expirationEnabled;
    }

    public int getExpirationDays() {
        return this.expirationDays;
    }
}

