/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.usertoken.plugin.api;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.usertoken.plugin.UserTokenRecord;
import com.sonatype.nexus.usertoken.plugin.UserTokenService;
import com.sonatype.nexus.usertoken.plugin.rest.model.UserTokenXO;
import io.swagger.annotations.Api;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.subject.PrincipalCollection;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.common.wonderland.AuthTicketService;
import org.sonatype.nexus.rest.NotCacheable;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.validation.Validate;

@Named
@Singleton
@Api(value="User: user token", hidden=true)
@Path(value="/internal/current-user/user-token")
@Produces(value={"application/json"})
public class CurrentUserUserTokenApiResource
extends ComponentSupport
implements Resource {
    public static final String RESOURCE_URI = "/internal/current-user/user-token";
    private final UserTokenService userTokenService;
    private final AuthTicketService authTicketService;

    @Inject
    public CurrentUserUserTokenApiResource(UserTokenService userTokenService, AuthTicketService authTicketService) {
        this.userTokenService = (UserTokenService)Preconditions.checkNotNull((Object)userTokenService);
        this.authTicketService = (AuthTicketService)Preconditions.checkNotNull((Object)authTicketService);
    }

    @GET
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:usertoken-current:read"})
    @Validate
    @NotCacheable
    public UserTokenXO readUserToken(@NotNull @Valid @QueryParam(value="authToken") String authToken) {
        this.validateUserTokenEnabled();
        this.validateAuthToken(authToken);
        UserTokenRecord record = this.userTokenService.current(true);
        if (record == null) {
            throw new NotFoundException("User token not found");
        }
        return this.getUserTokenXO(record);
    }

    @GET
    @Path(value="/attributes")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:usertoken-current:read"})
    @Validate
    @NotCacheable
    public Map<String, String> getAttributes() {
        this.validateUserTokenEnabled();
        HashMap<String, String> attributes = new HashMap<String, String>();
        Boolean expirationEnabled = this.userTokenService.isExpirationEnabled();
        attributes.put("expirationEnabled", String.valueOf(expirationEnabled));
        if (!expirationEnabled.booleanValue()) {
            return attributes;
        }
        Long expirationTimestamp = this.extractExpirationTimestamp(this.userTokenService.calculateExpirationTimestamp());
        this.validateUserTokenExpiration(expirationTimestamp);
        attributes.put("expirationTimeTimestamp", String.valueOf(expirationTimestamp));
        return attributes;
    }

    @DELETE
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:usertoken-current:delete"})
    @Validate
    public void resetUserToken(@NotNull @Valid @QueryParam(value="authToken") String authToken) {
        this.validateUserTokenEnabled();
        this.validateAuthToken(authToken);
        PrincipalCollection principals = SecurityUtils.getSubject().getPrincipals();
        this.userTokenService.remove(principals);
    }

    @POST
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:usertoken-current:create"})
    @Validate
    @NotCacheable
    public UserTokenXO createUserToken(@NotNull @Valid @QueryParam(value="authToken") String authToken) {
        this.validateUserTokenEnabled();
        this.validateAuthToken(authToken);
        UserTokenRecord record = this.userTokenService.create();
        return this.getUserTokenXO(record);
    }

    private UserTokenXO getUserTokenXO(UserTokenRecord record) {
        return new UserTokenXO().withNameCode(record.getUserToken().getNameCode()).withPassCode(String.valueOf(record.getUserToken().getPassCode())).withCreated(record.getCreated());
    }

    private Long extractExpirationTimestamp(Optional<Long> expirationTimestamp) {
        return expirationTimestamp.orElseThrow(() -> new WebApplicationMessageException(Response.Status.NOT_FOUND, "User Token not found"));
    }

    private void validateUserTokenExpiration(Long expirationTimeTimestamp) {
        if (expirationTimeTimestamp < DateTime.now().getMillis()) {
            throw new WebApplicationMessageException(Response.Status.NOT_FOUND, "User Token expired");
        }
    }

    private void validateUserTokenEnabled() {
        if (!this.userTokenService.isEnabled()) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, "User-token feature is not enabled");
        }
    }

    private void validateAuthToken(String b64AuthToken) {
        Preconditions.checkNotNull((Object)b64AuthToken);
        String authToken = Strings2.decodeBase64((String)b64AuthToken);
        this.log.debug("Validating authentication ticket: {}", (Object)authToken);
        if (!this.authTicketService.redeemTicket(authToken)) {
            throw new WebApplicationMessageException(Response.Status.UNAUTHORIZED, "Invalid authentication ticket");
        }
    }
}

