/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.selector;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SelectorSqlBuilder {
    protected final StringBuilder queryBuilder = new StringBuilder();
    private final Map<String, String> queryParameters = new HashMap<String, String>();
    private final Map<String, String> propertyAliases = new HashMap<String, String>();
    private String propertyPrefix = "";
    private String parameterNamePrefix = "";
    private String parameterPrefix = "";
    private String parameterSuffix = "";

    public SelectorSqlBuilder propertyAlias(String name, String alias) {
        this.propertyAliases.put((String)Preconditions.checkNotNull((Object)name), (String)Preconditions.checkNotNull((Object)alias));
        return this;
    }

    public SelectorSqlBuilder propertyPrefix(String prefix) {
        this.propertyPrefix = (String)Preconditions.checkNotNull((Object)prefix);
        return this;
    }

    public SelectorSqlBuilder parameterPrefix(String prefix) {
        this.parameterPrefix = (String)Preconditions.checkNotNull((Object)prefix);
        return this;
    }

    public SelectorSqlBuilder parameterNamePrefix(String namePrefix) {
        this.parameterNamePrefix = (String)Preconditions.checkNotNull((Object)namePrefix);
        return this;
    }

    public SelectorSqlBuilder parameterSuffix(String suffix) {
        this.parameterSuffix = (String)Preconditions.checkNotNull((Object)suffix);
        return this;
    }

    public void appendProperty(String property) {
        this.queryBuilder.append(this.propertyAliases.computeIfAbsent(property, p -> {
            Preconditions.checkArgument((boolean)StringUtils.isAlphanumeric((String)p));
            return String.valueOf(this.propertyPrefix) + p;
        }));
    }

    public void appendLiteral(String literal) {
        String parameter = String.valueOf(this.parameterNamePrefix) + this.queryParameters.size();
        this.queryBuilder.append(this.parameterPrefix).append(parameter).append(this.parameterSuffix);
        this.queryParameters.put(parameter, literal);
    }

    public void appendOperator(String operator) {
        this.queryBuilder.append(' ').append(operator).append(' ');
    }

    public void appendExpression(Runnable expression) {
        this.queryBuilder.append('(');
        expression.run();
        this.queryBuilder.append(')');
    }

    public String getQueryString() {
        return this.queryBuilder.toString();
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public void clearQueryString() {
        this.queryBuilder.setLength(0);
        this.queryParameters.clear();
    }
}

