/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.selector;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.ConstraintViolationException;
import org.apache.commons.jexl3.JexlException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.selector.CselSelector;
import org.sonatype.nexus.selector.CselToSql;
import org.sonatype.nexus.selector.CselValidator;
import org.sonatype.nexus.selector.JexlEngine;
import org.sonatype.nexus.selector.JexlSelector;
import org.sonatype.nexus.selector.Selector;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
@Singleton
public class SelectorFactory
extends ComponentSupport {
    private final JexlEngine jexlEngine = new JexlEngine();
    private final ConstraintViolationFactory constraintViolationFactory;
    private final CselToSql cselToSql;
    private boolean orientEnabled;

    @Inject
    public SelectorFactory(ConstraintViolationFactory constraintViolationFactory, CselToSql cselToSql, @Named(value="nexus.orient.enabled") @Named(value="nexus.orient.enabled") boolean orientEnabled) {
        this.constraintViolationFactory = (ConstraintViolationFactory)Preconditions.checkNotNull((Object)constraintViolationFactory);
        this.cselToSql = (CselToSql)Preconditions.checkNotNull((Object)cselToSql);
        this.orientEnabled = orientEnabled;
    }

    public void validateSelector(String type, String expression) {
        try {
            switch (type) {
                case "jexl": {
                    this.jexlEngine.parseExpression(expression);
                    break;
                }
                case "csel": {
                    CselValidator.validateCselExpression(this.jexlEngine.parseExpression(expression));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown selector type: " + type);
                }
            }
        }
        catch (Exception e) {
            String detail = String.format("Invalid %s: %s", Strings2.upper((String)type), e instanceof JexlException ? JexlEngine.expandExceptionDetail((JexlException)e) : e.getMessage());
            this.log.debug(detail, (Throwable)e);
            throw new ConstraintViolationException(e.getMessage(), (Set)ImmutableSet.of((Object)this.constraintViolationFactory.createViolation("expression", detail)));
        }
    }

    public Selector createSelector(String type, String expression) {
        boolean shouldTrimLeadingSlash = this.orientEnabled;
        switch (type) {
            case "jexl": {
                return new JexlSelector(this.jexlEngine.buildExpression(expression, shouldTrimLeadingSlash));
            }
            case "csel": {
                return new CselSelector(this.cselToSql, this.jexlEngine.buildExpression(expression, shouldTrimLeadingSlash));
            }
        }
        throw new IllegalArgumentException("Unknown selector type: " + type);
    }
}

