/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.selector;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Priority;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.parser.ASTAndNode;
import org.apache.commons.jexl3.parser.ASTEQNode;
import org.apache.commons.jexl3.parser.ASTERNode;
import org.apache.commons.jexl3.parser.ASTIdentifier;
import org.apache.commons.jexl3.parser.ASTIdentifierAccess;
import org.apache.commons.jexl3.parser.ASTJexlScript;
import org.apache.commons.jexl3.parser.ASTNENode;
import org.apache.commons.jexl3.parser.ASTOrNode;
import org.apache.commons.jexl3.parser.ASTReference;
import org.apache.commons.jexl3.parser.ASTReferenceExpression;
import org.apache.commons.jexl3.parser.ASTSWNode;
import org.apache.commons.jexl3.parser.ASTStringLiteral;
import org.apache.commons.jexl3.parser.JexlNode;
import org.apache.commons.jexl3.parser.ParserVisitor;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.selector.CselToSql;
import org.sonatype.nexus.selector.ParserVisitorSupport;
import org.sonatype.nexus.selector.SelectorSqlBuilder;

@FeatureFlag(name="nexus.orient.enabled")
@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@Singleton
@VisibleForTesting
public class OrientCselToSql
extends ParserVisitorSupport
implements CselToSql<SelectorSqlBuilder> {
    @Override
    public void transformCselToSql(ASTJexlScript script, SelectorSqlBuilder builder) {
        script.childrenAccept((ParserVisitor)this, (Object)builder);
    }

    @Override
    protected Object doVisit(JexlNode node, Object data) {
        throw new JexlException(node, "Expression not supported in CSEL selector");
    }

    @Override
    protected Object visit(ASTOrNode node, Object data) {
        return this.transformOperator((JexlNode)node, "or", (SelectorSqlBuilder)data);
    }

    @Override
    protected Object visit(ASTAndNode node, Object data) {
        return this.transformOperator((JexlNode)node, "and", (SelectorSqlBuilder)data);
    }

    @Override
    protected Object visit(ASTEQNode node, Object data) {
        return this.transformOperator((JexlNode)node, "=", (SelectorSqlBuilder)data);
    }

    @Override
    protected Object visit(ASTERNode node, Object data) {
        return this.transformOperator((JexlNode)node, "matches", (SelectorSqlBuilder)data);
    }

    @Override
    protected Object visit(ASTSWNode node, Object data) {
        JexlNode leftChild = node.jjtGetChild(0);
        JexlNode rightChild = node.jjtGetChild(1);
        if (rightChild instanceof ASTStringLiteral) {
            this.transformStartsWithOperator(leftChild, rightChild, (SelectorSqlBuilder)data);
        } else {
            this.transformStartsWithOperator(rightChild, leftChild, (SelectorSqlBuilder)data);
        }
        return data;
    }

    @Override
    protected Object visit(ASTNENode node, Object data) {
        JexlNode leftChild = node.jjtGetChild(0);
        JexlNode rightChild = node.jjtGetChild(1);
        if (rightChild instanceof ASTStringLiteral) {
            this.transformNotEqualsOperator(leftChild, rightChild, (SelectorSqlBuilder)data);
        } else {
            this.transformNotEqualsOperator(rightChild, leftChild, (SelectorSqlBuilder)data);
        }
        return data;
    }

    @Override
    protected Object visit(ASTReferenceExpression node, Object data) {
        ((SelectorSqlBuilder)data).appendExpression(() -> {
            Object object2 = node.childrenAccept((ParserVisitor)this, data);
        });
        return data;
    }

    @Override
    protected Object visit(ASTStringLiteral node, Object data) {
        ((SelectorSqlBuilder)data).appendLiteral(node.getLiteral());
        return data;
    }

    @Override
    protected Object visit(ASTIdentifier node, Object data) {
        ((SelectorSqlBuilder)data).appendProperty(node.getName());
        return data;
    }

    @Override
    protected Object visit(ASTReference node, Object data) {
        ASTIdentifierAccess subRef = (ASTIdentifierAccess)node.jjtGetChild(1);
        ((SelectorSqlBuilder)data).appendProperty(subRef.getName());
        return data;
    }

    private SelectorSqlBuilder transformOperator(JexlNode node, String operator, SelectorSqlBuilder builder) {
        JexlNode leftChild = node.jjtGetChild(0);
        JexlNode rightChild = node.jjtGetChild(1);
        leftChild.jjtAccept((ParserVisitor)this, (Object)builder);
        builder.appendOperator(operator);
        rightChild.jjtAccept((ParserVisitor)this, (Object)builder);
        return builder;
    }

    private SelectorSqlBuilder transformStartsWithOperator(JexlNode node, JexlNode literal, SelectorSqlBuilder builder) {
        this.throwExceptionIfNotLiteral(literal);
        node.jjtAccept((ParserVisitor)this, (Object)builder);
        builder.appendOperator("like");
        builder.appendLiteral(String.valueOf(((ASTStringLiteral)literal).getLiteral()) + '%');
        return builder;
    }

    private SelectorSqlBuilder transformNotEqualsOperator(JexlNode node, JexlNode literal, SelectorSqlBuilder builder) {
        this.throwExceptionIfNotLiteral(literal);
        builder.appendExpression(() -> {
            node.jjtAccept((ParserVisitor)this, (Object)builder);
            builder.appendOperator("is null or");
            node.jjtAccept((ParserVisitor)this, (Object)builder);
            builder.appendOperator("<>");
            literal.jjtAccept((ParserVisitor)this, (Object)builder);
        });
        return builder;
    }

    private void throwExceptionIfNotLiteral(JexlNode literal) {
        if (!(literal instanceof ASTStringLiteral)) {
            throw new JexlException(literal, "Expected string literal");
        }
    }
}

