/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.selector;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.jexl3.JexlContext;
import org.sonatype.nexus.selector.CselToSql;
import org.sonatype.nexus.selector.JexlExpression;
import org.sonatype.nexus.selector.Selector;
import org.sonatype.nexus.selector.SelectorSqlBuilder;
import org.sonatype.nexus.selector.VariableSource;

public class JexlSelector
implements Selector {
    public static final String TYPE = "jexl";
    protected final JexlExpression expression;

    public JexlSelector(JexlExpression expression) {
        this.expression = (JexlExpression)((Object)Preconditions.checkNotNull((Object)((Object)expression)));
    }

    @Override
    public boolean evaluate(VariableSource source) {
        return Boolean.TRUE.equals(this.expression.evaluate(JexlSelector.asJexlContext(source)));
    }

    @Override
    public void toSql(SelectorSqlBuilder sqlBuilder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void toSql(T sqlBuilder, CselToSql<T> cselToSql) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.expression.getParsedText();
    }

    private static JexlContext asJexlContext(final VariableSource source) {
        return new JexlContext(){
            private final Set<String> names;
            private final Map<String, Optional<?>> values;
            {
                this.names = variableSource.getVariableSet();
                this.values = new HashMap(this.names.size());
            }

            public boolean has(String name) {
                return this.names.contains(name);
            }

            public Object get(String name) {
                return this.values.computeIfAbsent(name, source::get).orElse(null);
            }

            public void set(String name, Object value) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

