/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.selector;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.selector.ContentSelectorCreatedEvent;
import org.sonatype.nexus.selector.ContentSelectorDeletedEvent;
import org.sonatype.nexus.selector.ContentSelectorEvent;
import org.sonatype.nexus.selector.ContentSelectorUpdatedEvent;
import org.sonatype.nexus.selector.SelectorConfiguration;

@Named
@Singleton
public class ContentSelectorAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "ContentSelector";

    public ContentSelectorAuditor() {
        this.registerType(ContentSelectorCreatedEvent.class, "created");
        this.registerType(ContentSelectorUpdatedEvent.class, "updated");
        this.registerType(ContentSelectorDeletedEvent.class, "deleted");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(ContentSelectorEvent event) {
        if (this.isRecording()) {
            SelectorConfiguration selectorConfiguration = event.getSelectorConfiguration();
            AuditData data = this.getSelectorAuditData(event, selectorConfiguration);
            this.record(data);
        }
    }

    private AuditData getSelectorAuditData(ContentSelectorEvent event, SelectorConfiguration selectorConfiguration) {
        AuditData data = new AuditData();
        data.setDomain(DOMAIN);
        data.setType(this.type(event.getClass()));
        data.setContext(selectorConfiguration.getName());
        Map attributes = data.getAttributes();
        attributes.put("description", selectorConfiguration.getDescription());
        attributes.put("type", selectorConfiguration.getType());
        attributes.put("expression", selectorConfiguration.getAttributes());
        return data;
    }
}

