/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.httpclient.internal;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.protocol.HttpContext;

public class NexusHttpRoutePlanner
extends DefaultRoutePlanner {
    private final Pattern nonProxyHostPattern;
    private final Map<String, HttpHost> proxies;

    public NexusHttpRoutePlanner(Map<String, HttpHost> proxies, @Nullable Pattern nonProxyHostsPattern) {
        super((SchemePortResolver)DefaultSchemePortResolver.INSTANCE);
        this.proxies = (Map)Preconditions.checkNotNull(proxies);
        this.nonProxyHostPattern = nonProxyHostsPattern;
    }

    protected HttpHost determineProxy(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        if (this.noProxyFor(host.getHostName())) {
            return null;
        }
        return this.proxies.get(host.getSchemeName());
    }

    private boolean noProxyFor(String hostName) {
        return this.nonProxyHostPattern != null && this.nonProxyHostPattern.matcher(hostName).matches();
    }
}

