/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.httpclient.config;

import java.util.Arrays;
import javax.annotation.Nullable;
import javax.validation.Valid;
import org.sonatype.nexus.httpclient.config.NonProxyHosts;
import org.sonatype.nexus.httpclient.config.ProxyServerConfiguration;

public class ProxyConfiguration
implements Cloneable {
    @Valid
    @Nullable
    private ProxyServerConfiguration http;
    @Valid
    @Nullable
    private ProxyServerConfiguration https;
    @NonProxyHosts
    @Nullable
    private String[] nonProxyHosts;

    @Nullable
    public ProxyServerConfiguration getHttp() {
        return this.http;
    }

    public void setHttp(@Nullable ProxyServerConfiguration http) {
        this.http = http;
    }

    @Nullable
    public ProxyServerConfiguration getHttps() {
        return this.https;
    }

    public void setHttps(@Nullable ProxyServerConfiguration https) {
        this.https = https;
    }

    @Nullable
    public String[] getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public void setNonProxyHosts(@Nullable String[] nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }

    public ProxyConfiguration copy() {
        try {
            ProxyConfiguration copy = (ProxyConfiguration)this.clone();
            if (this.http != null) {
                copy.http = this.http.copy();
            }
            if (this.https != null) {
                copy.https = this.https.copy();
            }
            if (this.nonProxyHosts != null) {
                copy.nonProxyHosts = (String[])this.nonProxyHosts.clone();
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "http=" + this.http + ", https=" + this.https + ", nonProxyHosts=" + Arrays.toString(this.nonProxyHosts) + '}';
    }
}

