/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.httpclient.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidatorContext;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.httpclient.config.NonProxyHosts;
import org.sonatype.nexus.validation.ConstraintValidatorSupport;

public class NonProxyHostsValidator
extends ConstraintValidatorSupport<NonProxyHosts, Collection<String>> {
    private static final Pattern CONTENT_PATTERN = Pattern.compile("\\*?[\\p{IsAlphabetic}|\\d|\\-|\\_|\\.|\\:|\\[|\\]]+\\*?");

    public boolean isValid(Collection<String> values, ConstraintValidatorContext context) {
        return values != null ? NonProxyHostsValidator.isValid(values) : true;
    }

    static boolean isValid(Collection<String> values) {
        for (String value : values) {
            if (NonProxyHostsValidator.isValid(value)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(String value) {
        if (Strings2.isBlank((String)value)) {
            return false;
        }
        if (value.indexOf(124) > -1) {
            return false;
        }
        return CONTENT_PATTERN.matcher(value).matches();
    }

    public static class ForArray
    extends ConstraintValidatorSupport<NonProxyHosts, String[]> {
        public boolean isValid(String[] values, ConstraintValidatorContext context) {
            return values != null ? NonProxyHostsValidator.isValid(Arrays.asList(values)) : true;
        }
    }
}

