/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.httpclient.config;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.sonatype.nexus.httpclient.config.BearerTokenAuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.NtlmAuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.UsernameAuthenticationConfiguration;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=BearerTokenAuthenticationConfiguration.class, name="bearerToken"), @JsonSubTypes.Type(value=NtlmAuthenticationConfiguration.class, name="ntlm"), @JsonSubTypes.Type(value=UsernameAuthenticationConfiguration.class, name="username")})
public abstract class AuthenticationConfiguration
implements Cloneable {
    public static final Map<String, Class<? extends AuthenticationConfiguration>> TYPES = ImmutableMap.of((Object)"username", UsernameAuthenticationConfiguration.class, (Object)"ntlm", NtlmAuthenticationConfiguration.class, (Object)"bearerToken", BearerTokenAuthenticationConfiguration.class);
    private final String type;
    private boolean preemptive;

    public AuthenticationConfiguration(String type) {
        this.type = (String)Preconditions.checkNotNull((Object)type);
    }

    public String getType() {
        return this.type;
    }

    public boolean isPreemptive() {
        return this.preemptive;
    }

    public void setPreemptive(boolean preemptive) {
        this.preemptive = preemptive;
    }

    public AuthenticationConfiguration copy() {
        try {
            return (AuthenticationConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

