/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.elasticsearch.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.elasticsearch.common.cli.Terminal;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginManager;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.app.BindAsLifecycleSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.app.ManagedLifecycleManager;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.thread.TcclBlock;
import org.sonatype.nexus.elasticsearch.PluginLocator;
import org.sonatype.nexus.elasticsearch.internal.PluginUsingNode;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.STORAGE)
@Singleton
public class NodeProvider
extends LifecycleSupport
implements Provider<Node> {
    private final ApplicationDirectories directories;
    private final NodeAccess nodeAccess;
    private final List<String> plugins;
    private final List<PluginLocator> pluginLocators;
    private Node node;

    @Inject
    public NodeProvider(ApplicationDirectories directories, NodeAccess nodeAccess, @Nullable @Named(value="${nexus.elasticsearch.plugins}") @Nullable @Named(value="${nexus.elasticsearch.plugins}") String plugins, @Nullable List<PluginLocator> pluginLocators) {
        this.directories = (ApplicationDirectories)Preconditions.checkNotNull((Object)directories);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.plugins = plugins == null ? new ArrayList() : Splitter.on((String)",").splitToList((CharSequence)plugins);
        this.pluginLocators = pluginLocators == null ? Collections.emptyList() : pluginLocators;
    }

    public synchronized Node get() {
        if (this.node == null) {
            try {
                Node newNode = this.create();
                this.log.debug("Waiting for yellow-status");
                newNode.client().admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().execute().actionGet();
                this.node = newNode;
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.node;
    }

    private Node create() throws Exception {
        File file = new File(this.directories.getConfigDirectory("fabric"), "elasticsearch.yml");
        Preconditions.checkState((boolean)file.exists(), (String)"Missing configuration: %s", (Object)file);
        this.log.info("Creating node with config: {}", (Object)file);
        Settings.Builder settings = Settings.builder().loadFromPath(file.toPath());
        settings.put("node.name", this.nodeAccess.getId());
        settings.put("path.plugins", new File(this.directories.getInstallDirectory(), "plugins").getAbsolutePath());
        NodeBuilder builder = NodeBuilder.nodeBuilder().settings(settings);
        if (!this.plugins.isEmpty()) {
            PluginManager pluginManager = new PluginManager(new Environment(settings.build()), null, PluginManager.OutputMode.VERBOSE, new TimeValue(30000L));
            for (String plugin : this.plugins) {
                try {
                    pluginManager.downloadAndExtract(plugin, Terminal.DEFAULT, true);
                }
                catch (IOException iOException) {
                    this.log.warn("Failed to install elasticsearch plugin: {}", (Object)plugin);
                }
            }
        }
        Throwable throwable = null;
        Object var5_7 = null;
        try (TcclBlock tccl = TcclBlock.begin((ClassLoader)NodeProvider.class.getClassLoader());){
            return new PluginUsingNode(builder.settings().build(), this.deployedPluginClasses()).start();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Collection<Class<? extends Plugin>> deployedPluginClasses() {
        return this.pluginLocators.stream().map(PluginLocator::pluginClass).collect(Collectors.toList());
    }

    protected void doStop() {
        if (this.node != null && ManagedLifecycleManager.isShuttingDown()) {
            this.log.debug("Shutting down");
            try {
                this.node.close();
            }
            finally {
                this.node = null;
            }
        }
    }

    @Named
    private static class BindAsLifecycle
    extends BindAsLifecycleSupport<NodeProvider> {
        private BindAsLifecycle() {
        }
    }
}

