/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ssl.internal;

import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.X509KeyManager;

public class ReloadableX509KeyManager
implements X509KeyManager {
    private X509KeyManager delegateKeyManager;

    private ReloadableX509KeyManager(X509KeyManager delegateKeyManager) {
        this.setDelegateKeyManager(delegateKeyManager);
    }

    @Override
    public String[] getClientAliases(String s, Principal[] principals) {
        return this.delegateKeyManager.getClientAliases(s, principals);
    }

    @Override
    public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
        return this.delegateKeyManager.chooseClientAlias(strings, principals, socket);
    }

    @Override
    public String[] getServerAliases(String s, Principal[] principals) {
        return this.delegateKeyManager.getServerAliases(s, principals);
    }

    @Override
    public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
        return this.delegateKeyManager.chooseServerAlias(s, principals, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String s) {
        return this.delegateKeyManager.getCertificateChain(s);
    }

    @Override
    public PrivateKey getPrivateKey(String s) {
        return this.delegateKeyManager.getPrivateKey(s);
    }

    private void setDelegateKeyManager(X509KeyManager delegateKeyManager) {
        this.delegateKeyManager = delegateKeyManager;
    }

    public static ReloadableX509KeyManager replaceX509KeyManager(ReloadableX509KeyManager reloadableX509KeyManager, KeyManager[] keyManagers) throws NoSuchAlgorithmException {
        int ii = 0;
        while (ii < keyManagers.length) {
            if (ReloadableX509KeyManager.class.isInstance(keyManagers[ii])) {
                throw new IllegalStateException("A ReloadableX509KeyManager has already been set for this KeyManager[]");
            }
            if (X509KeyManager.class.isInstance(keyManagers[ii])) {
                if (reloadableX509KeyManager == null) {
                    reloadableX509KeyManager = new ReloadableX509KeyManager((X509KeyManager)keyManagers[ii]);
                } else {
                    reloadableX509KeyManager.setDelegateKeyManager((X509KeyManager)keyManagers[ii]);
                }
                keyManagers[ii] = reloadableX509KeyManager;
                return reloadableX509KeyManager;
            }
            ++ii;
        }
        throw new NoSuchAlgorithmException("No X509KeyManager found in KeyManager[]");
    }
}

