/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ssl;

import com.google.common.base.Preconditions;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.ssl.KeyStoreManagerConfiguration;

public class KeyStoreManagerConfigurationSupport
extends ComponentSupport
implements KeyStoreManagerConfiguration {
    private static final String DEFAULT = "DEFAULT";
    private String keyStoreType = "JKS";
    private String keyAlgorithm = "RSA";
    private int keyAlgorithmSize = 2048;
    private Time certificateValidity = Time.days((long)36500L);
    private String signatureAlgorithm = "SHA1WITHRSA";
    private String keyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    private String trustManagerAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
    private char[] privateKeyStorePassword;
    private char[] trustedKeyStorePassword;
    private char[] privateKeyPassword;

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = (String)Preconditions.checkNotNull((Object)keyStoreType);
        this.log.debug("Key-store type: {}", (Object)keyStoreType);
    }

    @Override
    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = (String)Preconditions.checkNotNull((Object)keyAlgorithm);
        this.log.debug("Key algorithm: {}", (Object)keyAlgorithm);
    }

    @Override
    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithmSize(int keyAlgorithmSize) {
        this.keyAlgorithmSize = keyAlgorithmSize;
        this.log.debug("Key algorithm size: {}", (Object)keyAlgorithmSize);
    }

    @Override
    public int getKeyAlgorithmSize() {
        return this.keyAlgorithmSize;
    }

    public void setCertificateValidity(Time certificateValidity) {
        this.certificateValidity = certificateValidity;
        this.log.debug("Certificate validity: {}", (Object)certificateValidity);
    }

    @Override
    public Time getCertificateValidity() {
        return this.certificateValidity;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = (String)Preconditions.checkNotNull((Object)signatureAlgorithm);
        this.log.debug("Signature algorithm: {}", (Object)signatureAlgorithm);
    }

    @Override
    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        Preconditions.checkNotNull((Object)keyManagerAlgorithm);
        this.keyManagerAlgorithm = keyManagerAlgorithm.equals(DEFAULT) ? KeyManagerFactory.getDefaultAlgorithm() : keyManagerAlgorithm;
        this.log.debug("Key-manager algorithm: {}", (Object)this.keyManagerAlgorithm);
    }

    @Override
    public String getKeyManagerAlgorithm() {
        return this.keyManagerAlgorithm;
    }

    public void setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        Preconditions.checkNotNull((Object)trustManagerAlgorithm);
        this.trustManagerAlgorithm = trustManagerAlgorithm.equals(DEFAULT) ? TrustManagerFactory.getDefaultAlgorithm() : trustManagerAlgorithm;
        this.log.debug("Trust-manager algorithm: {}", (Object)this.trustManagerAlgorithm);
    }

    @Override
    public String getTrustManagerAlgorithm() {
        return this.trustManagerAlgorithm;
    }

    public void setPrivateKeyStorePassword(char[] password) {
        this.privateKeyStorePassword = password;
    }

    @Override
    public char[] getPrivateKeyStorePassword() {
        return this.privateKeyStorePassword;
    }

    public void setTrustedKeyStorePassword(char[] password) {
        this.trustedKeyStorePassword = password;
    }

    @Override
    public char[] getTrustedKeyStorePassword() {
        return this.trustedKeyStorePassword;
    }

    public void setPrivateKeyPassword(char[] password) {
        this.privateKeyPassword = password;
    }

    @Override
    public char[] getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "keyStoreType='" + this.keyStoreType + '\'' + ", keyAlgorithm='" + this.keyAlgorithm + '\'' + ", keyAlgorithmSize=" + this.keyAlgorithmSize + ", certificateValidity=" + this.certificateValidity + ", signatureAlgorithm='" + this.signatureAlgorithm + '\'' + ", keyManagerAlgorithm='" + this.keyManagerAlgorithm + '\'' + ", trustManagerAlgorithm='" + this.trustManagerAlgorithm + '\'' + '}';
    }
}

