/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ssl;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CertificateUtil {
    private static final Logger log = LoggerFactory.getLogger(CertificateUtil.class);

    private CertificateUtil() {
    }

    public static X509Certificate generateCertificate(PublicKey publicKey, PrivateKey privateKey, String algorithm, int validDays, String commonName, String orgUnit, String organization, String locality, String state, String country) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException, CertificateEncodingException {
        X509V3CertificateGenerator certificateGenerator = new X509V3CertificateGenerator();
        Vector<ASN1ObjectIdentifier> order = new Vector<ASN1ObjectIdentifier>();
        Hashtable<ASN1ObjectIdentifier, String> attributeMap = new Hashtable<ASN1ObjectIdentifier, String>();
        if (commonName != null) {
            attributeMap.put(X509Name.CN, commonName);
            order.add(X509Name.CN);
        }
        if (orgUnit != null) {
            attributeMap.put(X509Name.OU, orgUnit);
            order.add(X509Name.OU);
        }
        if (organization != null) {
            attributeMap.put(X509Name.O, organization);
            order.add(X509Name.O);
        }
        if (locality != null) {
            attributeMap.put(X509Name.L, locality);
            order.add(X509Name.L);
        }
        if (state != null) {
            attributeMap.put(X509Name.ST, state);
            order.add(X509Name.ST);
        }
        if (country != null) {
            attributeMap.put(X509Name.C, country);
            order.add(X509Name.C);
        }
        X509Name issuerDN = new X509Name(order, attributeMap);
        long now = System.currentTimeMillis();
        long expire = now + (long)validDays * 24L * 60L * 60L * 1000L;
        certificateGenerator.setNotBefore(new Date(now));
        certificateGenerator.setNotAfter(new Date(expire));
        certificateGenerator.setIssuerDN(issuerDN);
        certificateGenerator.setSubjectDN(issuerDN);
        certificateGenerator.setPublicKey(publicKey);
        certificateGenerator.setSignatureAlgorithm(algorithm);
        certificateGenerator.setSerialNumber(BigInteger.valueOf(now));
        return certificateGenerator.generate(privateKey);
    }

    public static String serializeCertificateInPEM(Certificate certificate) throws IOException {
        StringWriter buff = new StringWriter();
        Throwable throwable = null;
        Object var3_4 = null;
        try (JcaPEMWriter writer = new JcaPEMWriter((Writer)buff);){
            writer.writeObject((Object)certificate);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return buff.toString();
    }

    public static Certificate decodePEMFormattedCertificate(String pemFormattedCertificate) throws CertificateException {
        log.trace("Parsing PEM formatted certificate string:\n{}", (Object)pemFormattedCertificate);
        if (pemFormattedCertificate != null) {
            StringReader stringReader = new StringReader(pemFormattedCertificate);
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (PEMParser pemReader = new PEMParser((Reader)stringReader);){
                    Object object = pemReader.readObject();
                    log.trace("Object found while paring PEM formatted string: {}", object);
                    if (object instanceof X509CertificateHolder) {
                        X509CertificateHolder holder = (X509CertificateHolder)object;
                        JcaX509CertificateConverter converter = new JcaX509CertificateConverter();
                        return converter.getCertificate(holder);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new CertificateParsingException("Failed to parse valid certificate from expected PEM formatted certificate:\n" + pemFormattedCertificate, e);
            }
        }
        throw new CertificateParsingException("Failed to parse valid certificate from expected PEM formatted certificate:\n" + pemFormattedCertificate);
    }

    public static String calculateSha1(Certificate certificate) throws CertificateEncodingException {
        Preconditions.checkNotNull((Object)certificate);
        return Hashing.sha1().hashBytes(certificate.getEncoded()).toString().toUpperCase(Locale.US);
    }

    public static String calculateFingerprint(Certificate certificate) throws CertificateEncodingException {
        String sha1Hash = CertificateUtil.calculateSha1(certificate);
        return CertificateUtil.encode(sha1Hash, ':', 2);
    }

    public static Map<String, String> getIssuerRdns(X509Certificate certificate) throws InvalidNameException {
        return CertificateUtil.getRdns(certificate.getIssuerX500Principal().getName());
    }

    public static Map<String, String> getSubjectRdns(X509Certificate certificate) throws InvalidNameException {
        return CertificateUtil.getRdns(certificate.getSubjectX500Principal().getName());
    }

    private static Map<String, String> getRdns(String dn) throws InvalidNameException {
        HashMap<String, String> rdns = new HashMap<String, String>();
        LdapName ldapName = new LdapName(dn);
        for (Rdn rdn : ldapName.getRdns()) {
            rdns.put(rdn.getType(), rdn.getValue().toString());
        }
        return rdns;
    }

    private static String encode(String input, char separator, int delay) {
        StringBuilder buff = new StringBuilder();
        int i = 0;
        char[] cArray = input.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (i != 0 && i % delay == 0) {
                buff.append(separator);
            }
            buff.append(c);
            ++i;
            ++n2;
        }
        return buff.toString();
    }
}

