/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ssl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.Socket;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.httpclient.HttpClientManager;
import org.sonatype.nexus.httpclient.HttpClientPlan;
import org.sonatype.nexus.ssl.TrustStore;

@Singleton
@Named
public class CertificateRetriever
extends ComponentSupport {
    private final HttpClientManager httpClientManager;
    private final TrustStore trustStore;
    private static final TrustManager ACCEPT_ALL_TRUST_MANAGER = new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    };

    @Inject
    public CertificateRetriever(HttpClientManager httpClientManager, TrustStore trustStore) {
        this.httpClientManager = (HttpClientManager)Preconditions.checkNotNull((Object)httpClientManager);
        this.trustStore = (TrustStore)Preconditions.checkNotNull((Object)trustStore);
    }

    public Certificate[] retrieveCertificatesFromHttpsServer(String host, int port) throws Exception {
        Preconditions.checkNotNull((Object)host);
        this.log.info("Retrieving certificate from https://{}:{}", (Object)host, (Object)port);
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(this.trustStore.getKeyManagers(), new TrustManager[]{ACCEPT_ALL_TRUST_MANAGER}, null);
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sc, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
        BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager((Lookup)registry);
        try {
            AtomicReference certificates = new AtomicReference();
            CloseableHttpClient httpClient = this.httpClientManager.create(new HttpClientPlan.Customizer((HttpClientConnectionManager)connectionManager, certificates){
                private final /* synthetic */ HttpClientConnectionManager val$connectionManager;
                private final /* synthetic */ AtomicReference val$certificates;
                {
                    this.val$connectionManager = httpClientConnectionManager;
                    this.val$certificates = atomicReference;
                }

                public void customize(HttpClientPlan plan) {
                    plan.getClient().setConnectionManager(this.val$connectionManager);
                    plan.getClient().addInterceptorFirst(new HttpResponseInterceptor(){

                        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                            SSLSession session;
                            ManagedHttpClientConnection connection = (ManagedHttpClientConnection)HttpCoreContext.adapt((HttpContext)context).getConnection(ManagedHttpClientConnection.class);
                            if (connection != null && (session = connection.getSSLSession()) != null) {
                                val$certificates.set(session.getPeerCertificates());
                            }
                        }
                    });
                }
            });
            httpClient.execute((HttpUriRequest)new HttpGet("https://" + host + ":" + port));
            Certificate[] certificateArray = (Certificate[])certificates.get();
            return certificateArray;
        }
        catch (IOException e) {
            this.log.warn(e.getMessage());
            throw new IOException("Could not retrieve an SSL certificate from '" + host + ":" + port + "'");
        }
        finally {
            connectionManager.shutdown();
        }
    }

    public Certificate[] retrieveCertificates(String host, int port) throws Exception {
        Preconditions.checkNotNull((Object)host);
        this.log.info("Retrieving certificate from {}:{} using direct socket connection", (Object)host, (Object)port);
        try (Socket socket = null;){
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(this.trustStore.getKeyManagers(), new TrustManager[]{ACCEPT_ALL_TRUST_MANAGER}, null);
            SSLSocketFactory sslSocketFactory = sc.getSocketFactory();
            socket = (SSLSocket)sslSocketFactory.createSocket(host, port);
            ((SSLSocket)socket).startHandshake();
            SSLSession session = ((SSLSocket)socket).getSession();
            Certificate[] certificateArray = session.getPeerCertificates();
            return certificateArray;
        }
    }

    public Certificate[] retrieveCertificates(String host, Integer port, String protocolHint) throws Exception {
        int actualPort;
        int n = actualPort = port != null ? port : 443;
        if ("https".equalsIgnoreCase(protocolHint)) {
            return this.retrieveCertificatesFromHttpsServer(host, actualPort);
        }
        try {
            return this.retrieveCertificates(host, actualPort);
        }
        catch (Exception e) {
            if (protocolHint == null) {
                this.log.debug("Cannot connect directly to {}:{}. Will retry using https protocol.", new Object[]{host, actualPort, e});
                return this.retrieveCertificatesFromHttpsServer(host, actualPort);
            }
            this.log.debug("Cannot connect directly to {}:{}.", new Object[]{host, actualPort, e});
            return null;
        }
    }
}

