/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.template;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringEscapeUtils;
import org.sonatype.nexus.common.encoding.EncodingUtil;
import org.sonatype.nexus.common.template.TemplateAccessible;

@TemplateAccessible
public class EscapeHelper {
    public String html(String value) {
        return StringEscapeUtils.escapeHtml((String)value);
    }

    public String html(Object value) {
        return this.html(String.valueOf(value));
    }

    public String url(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        return EncodingUtil.urlEncode(value);
    }

    public String url(Object value) {
        return this.url(String.valueOf(value));
    }

    public String xml(String value) {
        return StringEscapeUtils.escapeXml((String)value);
    }

    public String xml(Object value) {
        return this.xml(String.valueOf(value));
    }

    public String uri(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        return this.url(value).replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
    }

    private String transform(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        return value.replace("%", "%25").replace(":", "%3A").replace(" ", "%20");
    }

    public String uri(Object value) {
        return this.uri(String.valueOf(value));
    }

    public String uriSegments(String value) {
        return Stream.of(value.split("/")).map(this::transform).collect(Collectors.joining("/"));
    }

    public String stripJavaEl(String value) {
        if (value != null) {
            return value.replaceAll("\\$+\\{", "{").replaceAll("\\$+\\\\A\\{", "{");
        }
        return null;
    }
}

