/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.property;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.common.FileReplacer;
import org.sonatype.nexus.common.property.ImplicitSourcePropertiesFile;

public class PropertiesFile
extends ImplicitSourcePropertiesFile {
    private static final Logger log = LoggerFactory.getLogger(PropertiesFile.class);
    private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss,SSSZ");
    private final File file;

    public PropertiesFile(File file) {
        this.file = (File)Preconditions.checkNotNull((Object)file);
    }

    @Override
    public void load() throws IOException {
        log.debug("Loading: {}", (Object)this.file);
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));){
            this.load(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void store() throws IOException {
        this.store(null);
    }

    public void store(String comments) throws IOException {
        log.debug("Storing: {}", (Object)this.file);
        FileReplacer replacer = new FileReplacer(this.file);
        replacer.setDeleteBackupFile(true);
        String comment = comments != null ? comments : this.timestamp();
        replacer.replace(output -> this.store(output, comment));
    }

    private String timestamp() {
        return new DateTime().toString(FORMATTER);
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean exists() throws IOException {
        return this.file.exists();
    }

    @Override
    public String toString() {
        return this.file + " " + super.toString();
    }
}

