/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.node;

import java.io.InputStream;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;

public abstract class NodeAccessSupport
extends StateGuardLifecycleSupport
implements NodeAccess {
    private final CompletableFuture<String> future = CompletableFuture.supplyAsync(this::compute);

    @Override
    public CompletionStage<String> getHostName() {
        return this.future;
    }

    private String compute() {
        Optional<Object> hostname;
        block14: {
            hostname = Optional.empty();
            try {
                Process process = Runtime.getRuntime().exec("hostname");
                process.waitFor(5L, TimeUnit.SECONDS);
                if (process.exitValue() != 0) break block14;
                Throwable throwable = null;
                Object var4_7 = null;
                try (InputStream in = process.getInputStream();){
                    hostname = Optional.ofNullable(IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.log.debug("Failed retrieve hostname from external process", (Throwable)e);
            }
        }
        if (hostname.isPresent()) {
            return (String)hostname.get();
        }
        try {
            hostname = Optional.ofNullable(InetAddress.getLocalHost().getHostName());
        }
        catch (Exception e) {
            this.log.debug("Failed to retrieve hostname from InetAddress", (Throwable)e);
        }
        this.log.error("Failed to determine hostname, using nodeId instead.");
        return hostname.map(String::trim).orElse(this.getId());
    }
}

