/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipSupport {
    private static final Logger log = LoggerFactory.getLogger(ZipSupport.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void zipFiles(Path path, List<String> filesToZip, String zipFileName) throws IOException {
        byte[] buffer = new byte[1024];
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            FileOutputStream fos = new FileOutputStream(zipFileName);
            try {
                try (ZipOutputStream zos = new ZipOutputStream(fos);){
                    for (String fileName : filesToZip) {
                        int length;
                        File file = path.resolve(fileName).toFile();
                        if (!file.exists()) {
                            log.info("The file '" + fileName + "' does not exist in folder '" + path + "'.");
                            continue;
                        }
                        FileInputStream fis = new FileInputStream(file);
                        zos.putNextEntry(new ZipEntry(fileName));
                        while ((length = fis.read(buffer)) > 0) {
                            zos.write(buffer, 0, length);
                        }
                        zos.closeEntry();
                        fis.close();
                    }
                }
                if (fos == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            fos.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

