/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.io;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.io.CooperatingFuture;
import org.sonatype.nexus.common.io.Cooperation;
import org.sonatype.nexus.common.io.CooperationFactorySupport;

public abstract class ScopedCooperationFactorySupport
extends CooperationFactorySupport {
    @Override
    protected Cooperation build(String id, CooperationFactorySupport.Config config) {
        return new ScopedCooperation(id, config);
    }

    protected <T> CooperatingFuture<T> createFuture(String requestKey, CooperationFactorySupport.Config config) {
        return new CooperatingFuture(requestKey, config);
    }

    protected abstract <T> CooperatingFuture<T> beginCooperation(String var1, CooperatingFuture<T> var2);

    protected abstract <T> void endCooperation(String var1, CooperatingFuture<T> var2);

    protected abstract Stream<CooperatingFuture<?>> streamFutures(String var1);

    @Nullable
    protected <T> T join(Cooperation.IOCheck<T> request) throws IOException {
        return request.check();
    }

    private class ScopedCooperation
    implements Cooperation {
        private final String scope;
        private final CooperationFactorySupport.Config config;

        public ScopedCooperation(String id, CooperationFactorySupport.Config config) {
            this.scope = String.valueOf((String)Preconditions.checkNotNull((Object)id)) + ':';
            this.config = (CooperationFactorySupport.Config)Preconditions.checkNotNull((Object)config);
        }

        @Override
        public <T> T cooperate(String requestKey, Cooperation.IOCall<T> request) throws IOException {
            CooperatingFuture<T> myFuture = ScopedCooperationFactorySupport.this.createFuture(requestKey, this.config);
            String scopedKey = String.valueOf(this.scope) + requestKey;
            CooperatingFuture<T> theirFuture = ScopedCooperationFactorySupport.this.beginCooperation(scopedKey, myFuture);
            if (theirFuture == null) {
                try {
                    Object t = myFuture.call(request);
                    return t;
                }
                finally {
                    ScopedCooperationFactorySupport.this.endCooperation(scopedKey, myFuture);
                }
            }
            return theirFuture.cooperate(request);
        }

        @Override
        public <T> T join(Cooperation.IOCheck<T> request) throws IOException {
            return ScopedCooperationFactorySupport.this.join(request);
        }

        @Override
        public Map<String, Integer> getThreadCountPerKey() {
            return ScopedCooperationFactorySupport.this.streamFutures(this.scope).collect(Collectors.toMap(CooperatingFuture::getRequestKey, CooperatingFuture::getThreadCount));
        }
    }
}

