/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.io;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class ObjectInputStreamWithClassLoader
extends ObjectInputStream {
    private final LoadingFunction classLoading;

    public ObjectInputStreamWithClassLoader(InputStream inputStream, LoadingFunction classLoading) throws IOException {
        super(inputStream);
        this.classLoading = (LoadingFunction)Preconditions.checkNotNull((Object)classLoading);
    }

    public ObjectInputStreamWithClassLoader(InputStream inputStream, ClassLoader loader) throws IOException {
        super(inputStream);
        Preconditions.checkNotNull((Object)loader);
        this.classLoading = name -> Class.forName(name, false, loader);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass classDesc) throws ClassNotFoundException {
        return this.classLoading.loadClass(classDesc.getName());
    }

    @FunctionalInterface
    public static interface LoadingFunction {
        public Class<?> loadClass(String var1) throws ClassNotFoundException;
    }
}

