/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.graph.Graph;
import com.google.common.graph.Graphs;
import java.util.Comparator;

public class GraphUtil {
    public static <T> int depth(Graph<T> graph, T node, int initialDepth) {
        Preconditions.checkNotNull(graph);
        Preconditions.checkNotNull(node);
        Preconditions.checkState((boolean)graph.isDirected(), (Object)"unable to compute depth for an undirected graph");
        Preconditions.checkState((!Graphs.hasCycle(graph) ? 1 : 0) != 0, (Object)"unable to compute depth for a graph with cycles");
        int currentDepth = initialDepth + 1;
        return graph.successors(node).stream().map(successor -> GraphUtil.depth(graph, successor, currentDepth)).max(Comparator.comparing(Integer::intValue)).orElse(currentDepth);
    }
}

