/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.cooperation2.datastore;

import java.util.Arrays;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.common.cooperation2.datastore.internal.LocalCooperation2;
import org.sonatype.nexus.common.cooperation2.internal.DisabledCooperation2;
import org.sonatype.nexus.common.cooperation2.internal.MutableConfigSupport;

@Named(value="local")
@Singleton
public class DefaultCooperation2Factory
extends ComponentSupport
implements Cooperation2Factory {
    @Override
    public Cooperation2Factory.Builder configure() {
        return new DefaultCooperation2Builder();
    }

    protected static String stripGuice(Class<?> clazz, String ... keys) {
        String simpleName = clazz.getSimpleName();
        if (simpleName.contains("EnhancerByGuice") && clazz.getSuperclass() != null) {
            return DefaultCooperation2Factory.stripGuice(clazz.getSuperclass(), keys);
        }
        return Arrays.asList(keys).stream().collect(Collectors.joining("-", String.valueOf(simpleName) + '-', ""));
    }

    protected class DefaultCooperation2Builder
    extends MutableConfigSupport {
        protected DefaultCooperation2Builder() {
        }

        @Override
        public Cooperation2 build(String id) {
            if (!this.enabled) {
                DefaultCooperation2Factory.this.log.debug("Disabled cooperation: {}", (Object)id);
                return new DisabledCooperation2(id);
            }
            return new LocalCooperation2(id, this.copy());
        }

        @Override
        public Cooperation2 build(Class<?> id, String ... keys) {
            if (!this.enabled) {
                DefaultCooperation2Factory.this.log.debug("Disabled cooperation: {}", id);
                return new DisabledCooperation2(DefaultCooperation2Factory.stripGuice(id, keys));
            }
            return new LocalCooperation2(DefaultCooperation2Factory.stripGuice(id, keys), this.copy());
        }
    }
}

