/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.cooperation2;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.cooperation2.Config;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.CooperationKey;
import org.sonatype.nexus.common.cooperation2.IOCall;
import org.sonatype.nexus.common.cooperation2.datastore.internal.CooperatingFuture;
import org.sonatype.nexus.common.cooperation2.internal.Cooperation2Builder;

public abstract class ScopedCooperation2Support
extends ComponentSupport
implements Cooperation2 {
    private final ConcurrentMap<String, CooperatingFuture<?>> localFutures = new ConcurrentHashMap();
    protected final Config config;
    protected final String scope;

    protected ScopedCooperation2Support(String scope, Config config) {
        this.config = (Config)Preconditions.checkNotNull((Object)config);
        this.scope = (String)Preconditions.checkNotNull((Object)scope);
    }

    protected <T> CooperatingFuture<T> beginCooperation(String scopedKey, CooperatingFuture<T> future) {
        return this.localFutures.putIfAbsent(scopedKey, future);
    }

    protected <T> void endCooperation(String scopedKey, CooperatingFuture<T> future) {
        this.localFutures.remove(scopedKey, future);
    }

    @Override
    public <RET> Cooperation2.Builder<RET> on(IOCall<RET> workFunction) {
        return new ScopedCooperation2Builder<RET>(workFunction);
    }

    @Override
    public Map<String, Integer> getThreadCountPerKey() {
        return this.localFutures.values().stream().collect(Collectors.toMap(CooperatingFuture::getRequestKey, CooperatingFuture::getThreadCount));
    }

    public class ScopedCooperation2Builder<R>
    extends Cooperation2Builder<R> {
        protected CooperationKey cooperationKey;

        public ScopedCooperation2Builder(IOCall<R> workFunction) {
            super(workFunction);
        }

        protected R perform(Boolean failover) {
            try {
                Optional potentialResult;
                if (failover.booleanValue() && (potentialResult = this.checkFunction.check()).isPresent()) {
                    return (R)potentialResult.get();
                }
                return (R)this.workFunction.call();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public R cooperate(String action, String ... nestedScope) throws IOException {
            this.cooperationKey = CooperationKey.create(ScopedCooperation2Support.this.scope, action, nestedScope);
            CooperatingFuture<Object> myFuture = new CooperatingFuture<Object>(this.cooperationKey, ScopedCooperation2Support.this.config);
            String scopedKey = this.cooperationKey.getHashedKey();
            try {
                CooperatingFuture<Object> theirFuture = ScopedCooperation2Support.this.beginCooperation(scopedKey, myFuture);
                if (theirFuture != null) return (R)theirFuture.cooperate(this::perform);
                try {
                    Object object = myFuture.call(this::perform);
                    return (R)object;
                }
                finally {
                    ScopedCooperation2Support.this.endCooperation(scopedKey, myFuture);
                }
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        }
    }
}

