/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.cooperation2;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;

public class CooperationKey {
    private final String humanReadable;
    private final String derivedKey;

    private CooperationKey(String derivedkey, String humanReadable) {
        this.humanReadable = (String)Preconditions.checkNotNull((Object)humanReadable);
        this.derivedKey = (String)Preconditions.checkNotNull((Object)derivedkey);
    }

    public String getHashedKey() {
        return this.derivedKey;
    }

    public String getKey() {
        return this.humanReadable;
    }

    public int hashCode() {
        return Objects.hashCode(this.derivedKey);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof CooperationKey) {
            CooperationKey o = (CooperationKey)other;
            return Objects.equals(this.derivedKey, o.derivedKey);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.humanReadable) + "\n\tkey:" + this.derivedKey;
    }

    public static CooperationKey create(String scope, String action, String ... nestedScope) {
        StringJoiner joiner = new StringJoiner(":");
        joiner.add((CharSequence)Preconditions.checkNotNull((Object)scope, (Object)"scope may not be null"));
        joiner.add((CharSequence)Preconditions.checkNotNull((Object)action, (Object)"action may not be null"));
        Arrays.asList(nestedScope).forEach(joiner::add);
        String humanReadable = joiner.toString();
        String derivedKey = Hashing.farmHashFingerprint64().hashString((CharSequence)humanReadable, StandardCharsets.UTF_8).toString();
        return new CooperationKey(derivedKey, humanReadable);
    }
}

