/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.collect;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.collect.AttributeKey;

public class AttributesMap
implements Iterable<Map.Entry<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(AttributesMap.class);
    @JsonProperty
    protected final Map<String, Object> backing;

    public AttributesMap(Map<String, Object> backing) {
        this.backing = (Map)Preconditions.checkNotNull(backing);
    }

    public AttributesMap() {
        this(Maps.newHashMap());
    }

    public Map<String, Object> backing() {
        return this.backing;
    }

    @Nullable
    private <T> T coerce(Object value, TypeToken<T> type) {
        if (value != null) {
            log.trace("Coerce: {} -> {}", value, type);
            try {
                if (value instanceof Number) {
                    if (Date.class.equals((Object)type.getRawType())) {
                        return (T)new Date(((Number)value).longValue());
                    }
                    if (DateTime.class.equals((Object)type.getRawType())) {
                        return (T)new DateTime(((Number)value).longValue());
                    }
                    if (OffsetDateTime.class.equals((Object)type.getRawType())) {
                        return (T)OffsetDateTime.ofInstant(Instant.ofEpochMilli(((Number)value).longValue()), ZoneOffset.UTC);
                    }
                }
                if (Boolean.class.equals((Object)type.getRawType()) && value instanceof String) {
                    Boolean result = Boolean.valueOf((String)value);
                    Throwable stackThrow = null;
                    if (log.isDebugEnabled()) {
                        stackThrow = new Throwable("Unexpected Attribute Coercion. Stack trace output to locate area of concern:");
                    }
                    log.warn("Coerced Boolean Attribute from String. value={}, result={}", new Object[]{value, result, stackThrow});
                    return (T)result;
                }
                return type.getRawType().cast(value);
            }
            catch (ClassCastException ex) {
                log.warn("Invalid attempt to coerce Attribute into a {}. Original type {}. value={}", new Object[]{type.getType().getTypeName(), value.getClass().getName(), value, log.isDebugEnabled() ? ex : null});
                return null;
            }
        }
        return null;
    }

    @Nullable
    public Object get(String key) {
        Preconditions.checkNotNull((Object)key);
        return this.backing.get(key);
    }

    @Nullable
    public Object get(String key, @Nullable Object defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    @Nullable
    public <T> T get(Class<T> type) {
        Object value = this.get(AttributeKey.get(type));
        return type.cast(value);
    }

    public <T> T getOrCreate(Class<T> type) {
        T value = this.get(type);
        if (value == null) {
            try {
                Constructor<T> ctor = type.getDeclaredConstructor(new Class[0]);
                log.trace("Creating '{}' with constructor: {}", type, ctor);
                ctor.setAccessible(true);
                value = ctor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
            this.set(type, value);
        }
        return value;
    }

    @Nullable
    public <T> T get(Class<T> type, @Nullable T defaultValue) {
        T value = this.get(type);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    @Nullable
    public <T> T get(String key, TypeToken<T> type) {
        Preconditions.checkNotNull(type);
        Object value = this.get(key);
        return this.coerce(value, type);
    }

    @Nullable
    public <T> T get(String key, Class<T> type) {
        Preconditions.checkNotNull(type);
        return this.get(key, TypeToken.of(type));
    }

    @Nullable
    public <T> T get(String key, TypeToken<T> type, @Nullable T defaultValue) {
        T value = this.get(key, type);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    @Nullable
    public <T> T get(String key, Class<T> type, @Nullable T defaultValue) {
        Preconditions.checkNotNull(type);
        return this.get(key, TypeToken.of(type), defaultValue);
    }

    protected String missingKeyMessage(String key) {
        return "Missing: " + key;
    }

    public Object require(String key) {
        Object value = this.get(key);
        Preconditions.checkState((value != null ? 1 : 0) != 0, (Object)this.missingKeyMessage(key));
        return value;
    }

    public <T> T require(Class<T> type) {
        T value = this.get(type);
        Preconditions.checkState((value != null ? 1 : 0) != 0, (Object)this.missingKeyMessage(AttributeKey.get(type)));
        return value;
    }

    public <T> T require(String key, TypeToken<T> type) {
        Preconditions.checkNotNull(type);
        Object value = this.require(key);
        return this.coerce(value, type);
    }

    public <T> T require(String key, Class<T> type) {
        Preconditions.checkNotNull(type);
        return this.require(key, TypeToken.of(type));
    }

    @Nullable
    public Object set(String key, @Nullable Object value) {
        Preconditions.checkNotNull((Object)key);
        if (value == null) {
            return this.remove(key);
        }
        Object replaced = this.backing.put(key, value);
        if (log.isTraceEnabled()) {
            log.trace("Set: {}={} ({})", new Object[]{key, value, value.getClass().getName()});
        }
        return replaced;
    }

    @Nullable
    public Object compute(String key, Function<Object, ? extends Object> function) {
        return this.set(key, function.apply(this.get(key)));
    }

    @Nullable
    public <T> Object set(Class<T> type, @Nullable T value) {
        return this.set(AttributeKey.get(type), value);
    }

    @Nullable
    public Object remove(String key) {
        Preconditions.checkNotNull((Object)key);
        Object removed = this.backing.remove(key);
        if (removed != null) {
            log.trace("Removed: {}", (Object)key);
        }
        return removed;
    }

    @Nullable
    public Object remove(Class<?> type) {
        return this.remove(AttributeKey.get(type));
    }

    public boolean contains(String key) {
        Preconditions.checkNotNull((Object)key);
        return this.backing.containsKey(key);
    }

    public boolean contains(Class<?> type) {
        return this.contains(AttributeKey.get(type));
    }

    public Set<String> keys() {
        return this.backing.keySet();
    }

    public Set<Map.Entry<String, Object>> entries() {
        return this.backing.entrySet();
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.backing.entrySet().iterator();
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    public int size() {
        return this.backing.size();
    }

    public void clear() {
        this.backing.clear();
        log.trace("Cleared");
    }

    public String toString() {
        return this.backing.toString();
    }
}

