/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.app;

import java.util.List;
import org.sonatype.nexus.common.app.FreezeRequest;

public class ReadOnlyState {
    private final List<FreezeRequest> state;
    private final boolean detailed;

    public ReadOnlyState(List<FreezeRequest> state, boolean detailed) {
        this.state = state;
        this.detailed = detailed;
    }

    public boolean isFrozen() {
        return !this.state.isEmpty();
    }

    public String getSummaryReason() {
        if (!this.detailed || this.state.isEmpty()) {
            return "";
        }
        return "Requested by " + this.state.stream().filter(r -> !r.token().isPresent()).findAny().map(u -> String.format("an administrator at %s", u.frozenAt().toString("yyyy-MM-dd HH:mm:ss ZZ"))).orElse(String.format("%s running system task(s)", this.state.size()));
    }

    public boolean isSystemInitiated() {
        return this.state.stream().anyMatch(r -> r.token().isPresent());
    }
}

